/**
 * Google Conversions Tracking Code - Advertising & Marketing Module
 *
 * NOTICE OF LICENSE
 * This Licence is only valid for one installation, you can sell it to
 * your customer and personalize it, but you can't install more than one
 * Licences, to install more licences buy another licences first.
 *
 * @author    Pol Rué
 * @copyright Smart Modules
 * @license   One time license
 * @category advertising & marketing
 * @version 1.5.7
 * Registered Trademark & Property of Smart-Modules.pro
 *
 * ******************************************
 * *    Google Conversions Tracking Code    *
 * *      http://www.smart-modules.pro      *
 * *                V 1.5.7                 *
 * ******************************************
*/

$(document).ready(function() {
    var timer = '';
    var regex = /(([a-zA-Z]{2}-[a-zA-Z0-9]{6,})\/[a-zA-Z0-9\-\_]{12,})/g;
    $('#GC_CODE_PASTER').on('keyup keydown keypress focus focusout', function() {
        setValues($(this));
    });
    function setValues(e) {
        var code = e.val();
        if (timer !== '') {
            clearTimeout(timer);
        }
        timer = setTimeout(function() {
            var m = '';
            while ((m = regex.exec(code)) !== null) {
                // This is necessary to avoid infinite loops with zero-width matches
                if (m.index === regex.lastIndex) {
                    regex.lastIndex++;
                }
                if (m.length > 0) {
                    $('#GC_ADWORDS_ID').val(m[2]);
                    $('#GC_CONVERSION_ID').val(m[1]);
                }
            }
        }, 1500);
    }
});