{*
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2019 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<div class="panel pb10">
	<div class="row">
		<div class="col-md-6">
			<div class="panel">
				<div class="panel-heading">
					{l s='GOOGLE TAXONOMY' mod='gmerchantfeedes'}
					<span class="step-info pull-right">Step 1</span>
				</div>
				<div class="f-between taxonomy-lang-list">
					<ul class="bullet-list c-between">
					{foreach from=$languages item='lang'}
						<li>
							<a href="{$currentIndex|escape:'htmlall':'UTF-8'}&taxonomyForm&language_id={$lang['id_lang']|escape:'htmlall':'UTF-8'}"><span class="bullet {if isset($taxonomies[$lang['id_lang']]['taxonomy'])
								&& $taxonomies[$lang['id_lang']]['taxonomy']}l-green{/if}"></span>
								{$lang['iso_code']|escape:'htmlall':'UTF-8'}
							<span class="l-code-dec">
								({$lang['language_code']|escape:'htmlall':'UTF-8'})
							</span>
							</a>
						</li>
					{/foreach}
					</ul>
				</div>
			</div>
		</div>
		<div class="col-md-6">
			<div class="panel">
				<div class="panel-heading">
					{l s='LINKING YOUR CATEGORIES WITH GOOGLE CATEGORIES' mod='gmerchantfeedes'}
					<span class="step-info pull-right">Step 2</span>
				</div>

				<div class="f-between taxonomy-category-list">
					<ul class="bullet-list c-between">
					{foreach from=$languages item='lang'}
						<li>
							<a href="{$currentIndex|escape:'htmlall':'UTF-8'}&taxonomyCategoryForm&language_id={$lang['id_lang']}">
								<span class="bullet {if (isset($taxonomiesLight[$lang['id_lang']]['filling'])
								&& $taxonomiesLight[$lang['id_lang']]['filling']==1)} l-yellow {elseif (isset($taxonomiesLight[$lang['id_lang']]['filling']) && $taxonomiesLight[$lang['id_lang']]['filling']==2)}l-green{/if}"></span>
								{$lang['iso_code']|escape:'htmlall':'UTF-8'}
								<span class="l-code-dec">
									({$lang['language_code']|escape:'htmlall':'UTF-8'})
								</span>
							</a>
						</li>
					{/foreach}
					</ul>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">
			<ul class="bullet-list info">
				<li>
					<span class="bullet-success"></span> <span>{l s='Success' mod='gmerchantfeedes'}</span>
				</li>
				<li>
					<span class="bullet-not-completed"></span> <span>{l s='May work incrorrectly' mod='gmerchantfeedes'}</span>
				</li>
				<li>
					<span class="bullet-error"></span> <span>{l s='Need your action' mod='gmerchantfeedes'}</span>
				</li>
			</ul>
		</div>
	</div>
</div>
