{*
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2019 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<div class="panel">
	<div class="panel-heading">
		<i class="icon-list-ul"></i>
		{l s='Feeds' mod='gmerchantfeedes'} <span> ( {$feeds|count} )</span>
		<span class="step-info pull-right">{l s='Step 3' mod='gmerchantfeedes'}</span>
	</div>
	<table class="table">
		<thead>
		<tr class="tr">
			<th>{l s='Id' mod='gmerchantfeedes'}</th>
			<th class="fixed-width-xxl">
				<span class="title_box">
					{l s='Feed name' mod='gmerchantfeedes'}
				</span>
			</th>
			<th>
				<span class="title_box">
					{l s='Locale' mod='gmerchantfeedes'}
				</span>
			</th>
			<th>
				<span class="title_box">
					{l s='Country for shipping cost' mod='gmerchantfeedes'}
				</span>
			</th>
			<th>
				<span class="title_box">
					{l s='Currency' mod='gmerchantfeedes'}
				</span>
			</th>
			<th>
				<span class="title_box">
					{l s='Last update' mod='gmerchantfeedes'}
				</span>
			</th>
			<th class="text-right fixed-width-md"></th>
		</tr>
		</thead>
		<tbody>
		{if isset($feeds) && count($feeds)}
		{foreach from=$feeds item=feed}
			<tr>
				<td class="pointer js-toggle-ref" data-ref="view-{$feed['id_gmerchantfeedes']|intval}">
					{$feed['id_gmerchantfeedes']|intval}
				</td>
				<td class="pointer js-toggle-ref" data-ref="view-{$feed['id_gmerchantfeedes']|intval}">
					{$feed['name']|escape:'htmlall':'UTF-8'}
				</td>
				<td class="pointer js-toggle-ref" data-ref="view-{$feed['id_gmerchantfeedes']|intval}">
					{$feed['locale']|escape:'htmlall':'UTF-8'}
				</td>
				<td class="pointer js-toggle-ref" data-ref="view-{$feed['id_gmerchantfeedes']|intval}">
					{if isset($feed['country'])}{$feed['country']|escape:'htmlall':'UTF-8'}{/if}</td>
				<td class="pointer js-toggle-ref" data-ref="view-{$feed['id_gmerchantfeedes']|intval}">
					{if isset($feed['currency']['iso_code']) && !empty($feed['currency']['iso_code'])}{$feed['currency']['iso_code']|escape:'htmlall':'UTF-8'}{/if}
				</td>
				<td class="pointer js-toggle-ref" data-ref="view-{$feed['id_gmerchantfeedes']|intval}">
					{$feed['date_update']|escape:'htmlall':'UTF-8'}
				</td>
				<td class="text-right">
					<div class="btn-group-action">
						<div class="btn-group">
							<button data-ref="view-{$feed['id_gmerchantfeedes']|intval}"
									class="js-toggle-ref btn btn-primary btn-default">
								<i class="icon-search-plus"></i>
								{l s='Show url' mod='gmerchantfeedes'}
							</button><a href="{$currentIndex|escape:'htmlall':'UTF-8'}&updateFeed&id_gmerchantfeedes={$feed['id_gmerchantfeedes']|intval}" class="btn btn-default">
								<i class="icon-pencil"></i>
								{l s='Edit' mod='gmerchantfeedes'}
							</a><a href="{$currentIndex|escape:'htmlall':'UTF-8'}&deleteFeed&id_gmerchantfeedes={$feed['id_gmerchantfeedes']|intval}" title="Delete" class="delete btn btn-default">
								<i class="icon-trash"></i> {l s='Delete' mod='gmerchantfeedes'}
							</a>
						</div>
					</div>
				</td>
			</tr>
			<tr class="unhover hide-view-container view-{$feed['id_gmerchantfeedes']|escape:'htmlall':'UTF-8'}">
				<td colspan="7">
					<h4 class="ptop_15">{l s='Copy this link and insert it in Google Merchant Center' mod='gmerchantfeedes'}</h4>
					<div class="content-group-links">
						<span>{l s='Rebuild & Download link:' mod='gmerchantfeedes'}</span>
						<span class="btn btn-default pull-right" onclick="copyText('{$feed['cron']|escape:'html':'UTF-8'}')">
						{l s='Copy to clipboard' mod='gmerchantfeedes'}
					</span>
						<br/>
						<a target="_blank" href="{$feed['cron']|escape:'html':'UTF-8'}">
							{$feed['cron']|escape:'html':'UTF-8'}
						</a>

						<hr/>
						<h4>{l s='For more products quantity' mod='gmerchantfeedes'}</h4>

						{l s='Rebuild (for cronjob):' mod='gmerchantfeedes'}
						<span class="btn btn-default pull-right" onclick="copyText('{$feed['cron_rebuild']|escape:'html':'UTF-8'}')">
						{l s='Copy to clipboard' mod='gmerchantfeedes'}
					</span>
						<br/>
						<a target="_blank" href="{$feed['cron_rebuild']|escape:'html':'UTF-8'}">
							{$feed['cron_rebuild']|escape:'html':'UTF-8'}
						</a>

						<hr/>
						{l s='Download (for Google Merchant Center):' mod='gmerchantfeedes'}
						<span class="btn btn-default pull-right" onclick="copyText('{$feed['cron_download']|escape:'html':'UTF-8'}')">
						{l s='Copy to clipboard' mod='gmerchantfeedes'}
					</span><br/>
						<a target="_blank" href="{$feed['cron_download']|escape:'html':'UTF-8'}">
							{$feed['cron_download']|escape:'html':'UTF-8'}
						</a>
					</div>
					<br/>
					<button data-ref="view-{$feed['id_gmerchantfeedes']|intval}" class="btn-close-dropdown js-toggle-ref close-dropdown"></button>
					<br/>
				</td>
			</tr>
		{/foreach}
		{else}
			<tr>
				<td colspan="7">
					<p class="title-clear">
						{l s='No feeds' mod='gmerchantfeedes'}
					</p>
				</td>
			</tr>
		{/if}
		<tr class="unhover">
			<td class="text-center" colspan="7">
				<div class="btn-group-action add-btn">
					<a class="btn-group btn btn-primary pointer" href="{$currentIndex|escape:'htmlall':'UTF-8'}&addNewFeed">
						<span class="btn-group">
							<i class="process-icon-new"></i>
							<span>{l s='New feed' mod='gmerchantfeedes'}</span>
						</span>
					</a>
				</div>
			</td>
		</tr>
		</tbody>
	</table>
</div>

<script type="text/javascript">
	function copyText(str){
		const el = document.createElement('textarea');
		el.value = str;
		document.body.appendChild(el);
		el.select();
		document.execCommand('copy');
		document.body.removeChild(el);
	}
</script>