{*
* GcSiretProgram
*
* @author    Grégory Chartier <hello@gregorychartier.fr>
* @copyright 2018 Grégory Chartier (https://www.gregorychartier.fr)
* @license   Commercial license see license.txt
* @category  Prestashop
* @category  Module
*}

{extends 'customer/page.tpl'}

{block name='page_title'}
  {l s='SIRET Program' mod='gcsiretprogram'}
{/block}

{block name='page_content'}

{capture name=path}{l s='SIRET Program' mod='gcsiretprogram'}{/capture}

{if $ok && isset($ok)}
	<p class="alert alert-success">
		{$ok|escape:'html':'UTF-8'}
		{if $mode_manuel == 1 && $statut == 1}
			{l s='Il sera vérifié prochainement.' mod='gcsiretprogram'}
		{/if}
		{if $mode_manuel == 1 && $en_attente == 0}
			{l s='Vous aurez rapidement accès à notre boutique.' mod='gcsiretprogram'}
		{/if}
	</p>
{/if}

<form action="{$link->getModuleLink('gcsiretprogram', 'actions', ['process' => 'submitSiret'], true)|escape:'html':'UTF-8'}" method="post" class="box">
	<div class="form_content clearfix">
		<p>{l s='Vous devez fournir votre numero SIRET pour bénéficier des avantages réservés aux professionnels.' mod='gcsiretprogram'}</p>
		{if $erreur != ''}
			<div class="alert alert-danger" id="create_account_error">{$erreur|escape:'html':'UTF-8'}</div>
		{/if}
		
		<div class="form-group row ">
    		<label class="col-md-3 form-control-label " for="siret">
              {l s='SIRET number' mod='gcsiretprogram'}
          	</label>
    		<div class="col-md-6">
				<input type="text" class="form-control" id="siret" name="siret" value="{if $siret && isset($siret)}{$siret|escape:'htmlall':'UTF-8'}{/if}">
    		</div>
    		<div class="col-md-3 form-control-comment">          
    		</div>
  		</div>
		<div class="submit">
			<button class="btn btn-primary button form-control-submit pull-xs-right" type="submit" id="submitSiret" name="submitSiret">
				{l s='Validate' mod='gcsiretprogram'}
			</button>
		</div>
	</div>
</form>

{/block}
