{*
* GcSiretProgram
*
* @author    Grégory Chartier <hello@gregorychartier.fr>
* @copyright 2018 Grégory Chartier (https://www.gregorychartier.fr)
* @license   Commercial license see license.txt
* @category  Prestashop
* @category  Module
*}

<form action="{$uri|escape:'html':'UTF-8'}" method="post" name="lessiret">
        <div class="panel" id="fieldset_1">
            <div class="panel-heading"><i class="icon-cogs"></i> {l s='Liste de SIRET' mod='gcsiretprogram'}</div>
            <div class="table-responsive clearfix">
                <table class="table">
                    <thead>
                        <tr class="nodrag nodrop">
                            <th>{l s='Firstname' mod='gcsiretprogram'}</th>
                            <th>{l s='Lastname' mod='gcsiretprogram'}</th>
                            <th>{l s='Company' mod='gcsiretprogram'}</th>
                            <th>{l s='SIRET' mod='gcsiretprogram'}</th>
                            <th class="text-center"><span title="{l s='To validate' mod='gcsiretprogram'}"><img src="{$module_dir|escape:'html':'UTF-8'}views/img/aval.png" /></span></th>
                            <th class="text-center"><span title="{l s='Validate' mod='gcsiretprogram'}"><img src="{$module_dir|escape:'html':'UTF-8'}views/img/val.png" /></span></th>
                            <th class="text-center"><span title="{l s='Refuse' mod='gcsiretprogram'}"><img src="{$module_dir|escape:'html':'UTF-8'}views/img/del.png" /></span></th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach from=$sirets item=siret}
                            <tr>
                                <td>{$siret.firstname|escape:'html':'UTF-8'}</td>
                                <td>{$siret.lastname|escape:'html':'UTF-8'}</td>
                                <td>{$siret.company|escape:'html':'UTF-8'}</td>
                                <td><a style="color:#963" title="{l s='Contrôler sur Société.com' mod='gcsiretprogram'}" href="http://www.societe.com/cgi-bin/recherche?rncs={$siret.siret|truncate:9:""|escape:'htmlall':'UTF-8'}" target="_blank">{$siret.siret|escape:'htmlall':'UTF-8'}</a></td>
                                <td align="center"><input type="radio" {if $siret.statut == 1}checked{/if} name="check{$siret.id_customer|intval}" value="1" /></td>
                                <td align="center"><input type="radio" {if $siret.statut == 2}checked{/if} name="check{$siret.id_customer|intval}" value="2" /></td>
                                <td align="center"><input type="radio" {if $siret.statut == 3}checked{/if} name="check{$siret.id_customer|intval}" value="3" /></td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
            <div class="panel-footer">
            <button type="submit" value="1" id="module_form_submit_btn" name="submitValidation" class="btn btn-default pull-right">
                <i class="process-icon-save"></i> {l s='Validate' mod='gcsiretprogram'}
            </button>
            </div>
        </div>
</form>
