<?php
/**
 * GcSiretProgram
 *
 * @author    Grégory Chartier <hello@gregorychartier.fr>
 * @copyright 2018 Grégory Chartier (https://www.gregorychartier.fr)
 * @license   Commercial license see license.txt
 * @category  Prestashop
 * @category  Module
 */

class GcSiretProgramDefaultModuleFrontController extends ModuleFrontController
{
    public $auth = true;
    public $ssl = true;

    public function initContent()
    {
        if (!Context::getContext()->customer->id) {
            Tools::redirect(__PS_BASE_URI__);
        }

        parent::initContent();

        $this->context->controller->addCSS(_MODULE_DIR_ . $this->module->name . '/views/css/style.css');

        $sp     = new GcSiretProgram();
        $statut = $sp->getCustomerSIRET(Context::getContext()->customer->id);

        if ($statut) {
            $this->context->smarty->assign(array(
                'ok'     => $sp->l('SIRET enregistré.'),
                'siret'  => $statut['siret'],
                'statut' => $statut['statut']
            ));
        } else {
            $this->context->smarty->assign(array(
                'ok'     => '',
                'siret'  => '',
                'statut' => ''
            ));
        }

        $this->context->smarty->assign(array(
            'mode_manuel' => (int)Configuration::get('GCSIRET_MODE_MANUEL'),
            'en_attente'  => (int)Configuration::get('GCSIRET_ACCES_VALIDATION'),
            'erreur'      => '',
            'id_module'   => $this->module->id
        ));

        return $this->setTemplate('module:gcsiretprogram/views/templates/front/gcsiretprogram-program.tpl');
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();

        $breadcrumb['links'][] = $this->addMyAccountToBreadcrumb();

        return $breadcrumb;
    }
}
