<?php
/**
 * GcSiretProgram
 *
 * @author    Grégory Chartier <hello@gregorychartier.fr>
 * @copyright 2018 Grégory Chartier (https://www.gregorychartier.fr)
 * @license   Commercial license see license.txt
 * @category  Prestashop
 * @category  Module
 */

class GcSiretProgramActionsModuleFrontController extends ModuleFrontController
{
    public $customer;
    public $retour;

    public function init()
    {
        parent::init();

        $this->customer = new Customer(Context::getContext()->customer->id);
    }

    public function postProcess()
    {
        $the_siret = htmlspecialchars(Tools::getValue('siret'));
        $this->whatAboutSiret($the_siret);
    }

    public function initContent()
    {
        parent::initContent();

        if (!Context::getContext()->customer->id) {
            Tools::redirect(__PS_BASE_URI__);
        }

        $this->context->smarty->assign(array(
            'id_module' => $this->module->id
        ));

        $this->context->controller->addCSS(_MODULE_DIR_ . $this->module->name . '/views/css/style.css');

        return $this->setTemplate('module:gcsiretprogram/views/templates/front/gcsiretprogram-program.tpl');
    }

    public function whatAboutSiret($siret)
    {
        $sp = new GcSiretProgram();
        if (empty($siret) && Configuration::get('GCSIRET_OBLIGATOIRE')) {
            $this->context->smarty->assign('erreur', $sp->l('SIRET requis'));

            $this->context->smarty->assign(array(
                'mode_manuel' => (int)Configuration::get('GCSIRET_MODE_MANUEL'),
                'en_attente'  => (int)Configuration::get('GCSIRET_ACCES_VALIDATION'),
                'ok'          => $sp->l('SIRET supprimé.'),
                'siret'       => ''
            ));
        } else {
            if (empty($siret)) {
                $siret = '';
            }

            $statut = $sp->processSiret($siret, $this->customer);

            if ($siret === '') {
                $this->context->smarty->assign('ok', '');
                $this->context->smarty->assign('statut', '');
                $this->context->smarty->assign('erreur', $sp->l('SIRET invalide.'));
            } else {
                if ($statut == false) {
                    $this->context->smarty->assign('ok', '');
                    $this->context->smarty->assign('statut', '');
                    $this->context->smarty->assign('erreur', $sp->l('SIRET invalide.'));
                } else {
                    $this->context->smarty->assign('ok', $sp->l('SIRET enregistré.'));
                    $this->context->smarty->assign('statut', $statut);
                    $this->context->smarty->assign('erreur', '');
                }
            }

            $this->context->smarty->assign(array(
                'mode_manuel' => (int)Configuration::get('GCSIRET_MODE_MANUEL'),
                'en_attente'  => (int)Configuration::get('GCSIRET_ACCES_VALIDATION'),
                'siret'       => $siret
            ));
        }
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();

        $breadcrumb['links'][] = $this->addMyAccountToBreadcrumb();

        return $breadcrumb;
    }
}
