<?php
/**
 * Project : everpsimagealt
 * @author Team Ever
 * @copyright Team Ever
 * @license   Tous droits réservés / Le droit d'auteur s'applique (All rights reserved / French copyright law applies)
 * @link https://www.team-ever.com
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once _PS_MODULE_DIR_.'everpsimagealt/models/EverPsSeoImage.php';

class AdminEverPsSeoImageController extends ModuleAdminController
{
    private $html;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->lang = false;
        $this->table = 'ever_seo_image';
        $this->className = 'EverPsSeoImage';
        $this->context = Context::getContext();
        $this->identifier = 'id_ever_img';
        $this->imageType = 'jpg';
        $this->max_file_size = (int)(Configuration::get('PS_LIMIT_UPLOAD_FILE_VALUE') * 1000000);
        $this->max_image_size = (int)Configuration::get('PS_PRODUCT_PICTURE_MAX_SIZE');
        $this->allow_export = true;
        $moduleConfUrl  = 'index.php?controller=AdminModules&configure=everpsimagealt&token=';
        $moduleConfUrl .= Tools::getAdminTokenLite('AdminModules');

        $this->context->smarty->assign(array(
            'moduleConfUrl' => (string)$moduleConfUrl,
            'image_dir' => _PS_BASE_URL_.__PS_BASE_URI__ . '/modules/everpsimagealt/'
        ));

        $this->_select = 'l.iso_code, il.legend, il.id_image, pl.name';

        $this->_join =
            'LEFT JOIN `'._DB_PREFIX_.'ever_seo_lang` l
                ON (
                    l.`id_seo_lang` = a.`id_seo_lang`
                )
            LEFT JOIN `'._DB_PREFIX_.'image_lang` il
                ON (
                    il.`id_lang` = a.`id_seo_lang`
                    AND il.id_image = a.id_seo_img
                )
            LEFT JOIN `'._DB_PREFIX_.'product_lang` pl
                ON (
                    pl.id_product = a.id_seo_product
                )';

        $this->_where = 'AND a.id_shop ='.(int)$this->context->shop->id;

        $this->_group = 'GROUP BY a.id_ever_img';

        $this->fields_list = array(
            'id_ever_img' => array(
                'title' => $this->l('ID SEO Image'),
                'align' => 'left',
                'width' => 'auto'
            ),
            'id_seo_img' => array(
                'title' => $this->l('ID Image'),
                'align' => 'left',
                'width' => 'auto'
            ),
            'image' => array(
                'title' => $this->l('Image'),
                'align' => 'center',
                'image' => 'p',
                'orderby' => false,
                'filter' => false,
                'search' => false
            ),
            'name' => array(
                'title' => $this->l('Product'),
                'align' => 'left',
                'width' => 'auto'
            ),
            'legend' => array(
                'title' => $this->l('Alt/Title'),
                'align' => 'left',
                'width' => 'auto'
            ),
            'iso_code' => array(
                'title' => $this->l('Lang'),
                'align' => 'left',
                'width' => 'auto'
            )
        );

        $this->colorOnBackground = true;
        $this->isSeven = Tools::version_compare(_PS_VERSION_, '1.7', '>=') ? true : false;

        if ($this->isSeven) {
            $imageType = ImageType::getFormattedName('large');
        } else {
            $imageType = ImageType::getFormatedName('large');
        }

        $id_shop = (int)$this->context->shop->id;
        $id_lang = (int)$this->context->language->id;

        if (Tools::getValue('id_ever_img')) {
            $seoImage = new EverPsSeoImage(
                (int)Tools::getValue('id_ever_img')
            );
            $link = new Link();
            $product = new Product(
                (int)$seoImage->id_seo_product,
                (int)$id_shop,
                (int)$id_lang
            );
            $richImage = $product->getCover(
                (int)$product->id
            );
            $objectUrl = Tools::getShopProtocol().$link->getImageLink(
                $product->link_rewrite,
                $product->id.'-'.$richImage['id_image'],
                $imageType
            );
            $editUrl  = 'index.php?controller=AdminProducts&id_product='.(int)$product->id.'';
            $editUrl .= '&updateproduct&token='.Tools::getAdminTokenLite('AdminProducts');
            $objectGSearch = str_replace(' ', '+', $product->name);
            $this->context->smarty->assign(array(
                'headerObjectName' => $product->name.' image',
                'objectGSearch' => $objectGSearch,
                'objectUrl' => $objectUrl,
                'editUrl' => $editUrl,
            ));
        }

        parent::__construct();
    }

    public function initToolbar()
    {
        //Empty because of reasons :-)
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->addCSS(_PS_MODULE_DIR_.'everpsimagealt/views/css/ever.css');
    }

    protected function l($string, $class = null, $addslashes = false, $htmlentities = true)
    {
        if (_PS_VERSION_ >= '1.7') {
            return Context::getContext()->getTranslator()->trans($string);
        } else {
            return parent::l($string, $class, $addslashes, $htmlentities);
        }
    }

    public function renderList()
    {
        $this->html = '';

        $this->addRowAction('edit');
        
        $this->bulk_actions = array(
            'shortdescalt' => array(
                'text' => $this->l('Product short desc'),
                'confirm' => $this->l('Set default alt/title using current product short desc ?')
            ),
            'descalt' => array(
                'text' => $this->l('Product desc'),
                'confirm' => $this->l('Set default alt/title using current product description ?')
            ),
            'metaaltname' => array(
                'text' => $this->l('Product name as alt'),
                'confirm' => $this->l('Set product name as alt/title ?')
            ),
        );
        
        if (Tools::isSubmit('submitBulkshortdescalt'.$this->table)) {
            $this->processBulkShortdescalt();
        }
        
        if (Tools::isSubmit('submitBulkdescalt'.$this->table)) {
            $this->processBulkMetadescriptiondesc();
        }
        
        if (Tools::isSubmit('submitBulkmetaaltname'.$this->table)) {
            $this->processBulkMetaaltname();
        }

        $this->toolbar_title = $this->l('SEO setting : Images');

        $lists = parent::renderList();

        $this->html .= $this->context->smarty->fetch(
            _PS_MODULE_DIR_ . '/everpsimagealt/views/templates/admin/header.tpl'
        );
        if (count($this->errors)) {
            foreach ($this->errors as $error) {
                $this->html .= Tools::displayError($error);
            }
        }
        $this->html .= $lists;
        $this->html .= $this->context->smarty->fetch(
            _PS_MODULE_DIR_ . '/everpsimagealt/views/templates/admin/footer.tpl'
        );

        return $this->html;
    }

    public function renderForm()
    {
        if (Context::getContext()->shop->getContext() != Shop::CONTEXT_SHOP && Shop::isFeatureActive()) {
            $this->errors[] = $this->l('You have to select a shop before creating or editing new SEO rules.');
        }
        
        if (count($this->errors)) {
            return false;
        }
        
        $this->fields_form = array(
            'legend' => array(
            'title' => '',
            ),
            'submit' => array(
                'name' => 'save',
                'title' => $this->l('Save'),
                'class' => 'button pull-right'
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Alt/title (aka legend)'),
                    'required' => true,
                    'name' => 'alt',
                    'lang' => false,
                ),
            )
        );
        $lists = parent::renderForm();

        $this->html .= $this->context->smarty->fetch(
            _PS_MODULE_DIR_
            .'/everpsimagealt/views/templates/admin/headerobject.tpl'
        );
        $this->html .= $lists;
        $this->html .= $this->context->smarty->fetch(
            _PS_MODULE_DIR_
            .'/everpsimagealt/views/templates/admin/footer.tpl'
        );

        return $this->html;
    }

    public function postProcess()
    {
        parent::postProcess();

        if (Tools::isSubmit('save')) {
            if (!Tools::getValue('alt')
                || !Validate::isGenericName(Tools::getValue('alt'))
            ) {
                 $this->errors[] = $this->l('alt is invalid');
            }
            if (Tools::getValue('allowed_sitemap')
                && !Validate::isBool(Tools::getValue('allowed_sitemap'))
            ) {
                 $this->errors[] = $this->l('allowed_sitemap is invalid');
            }
            if (!count($this->errors)) {
                $everImg = new EverPsSeoImage(
                    (int)Tools::getValue('id_ever_img')
                );
                $image = new Image(
                    (int)$everImg->id_seo_img,
                    (int)$this->context->shop->id,
                    (int)$everImg->id_seo_lang
                );
                if (!$image->id_product) {
                    $this->errors[] = $this->l('No product linked');
                }
                $image->id_product = $everImg->id_seo_product;
                $image->legend = Tools::substr(Tools::getValue('alt'), 0, 125);
                $everImg->alt = Tools::substr(Tools::getValue('alt'), 0, 125);
                $everImg->allowed_sitemap = true;
                // Hook update triggered
                if (!$image->save() || !$everImg->save()) {
                    $this->errors[] = $this->l('Can\'t update the native object');
                } else {
                    Tools::redirectAdmin(self::$currentIndex.'&conf=4&token='.$this->token);
                }
            }
        }
    }

    protected function processBulkShortdescalt()
    {
        foreach (Tools::getValue($this->table.'Box') as $idEverImg) {
            $everImg = new EverPsSeoImage(
                (int)$idEverImg
            );
            $image = new Image(
                (int)$everImg->id_seo_img,
                (int)$this->context->shop->id,
                (int)$everImg->id_seo_lang
            );

            $description = Db::getInstance()->getValue(
                'SELECT description_short FROM `'._DB_PREFIX_.'product_lang`
                WHERE id_product = '.pSQL($everImg->id_seo_product).'
                AND id_lang = '.pSQL($everImg->id_seo_lang)
            );

            if (!$description) {
                continue;
            }
            if (!$image->id_product) {
                continue;
            }

            $everImg->alt = $description;
            $image->legend = strip_tags(Tools::substr($description, 0, 125).'');
            // Hook update triggered
            if (!$image->save()) {
                $this->errors[] = $this->l('Can\'t update the native object');
            }
        }
    }

    protected function processBulkMetaaltname()
    {
        foreach (Tools::getValue($this->table.'Box') as $idEverImg) {
            $everImg = new EverPsSeoImage(
                (int)$idEverImg
            );
            $image = new Image(
                $everImg->id_seo_img,
                (int)$this->context->shop->id,
                (int)$everImg->id_seo_lang
            );

            $name = Db::getInstance()->getValue(
                'SELECT name FROM `'._DB_PREFIX_.'product_lang`
                WHERE id_product = '.pSQL($everImg->id_seo_product).'
                AND id_lang = '.pSQL($everImg->id_seo_lang)
            );

            if (!$name) {
                continue;
            }
            if (!$image->id_product) {
                continue;
            }

            $everImg->alt = $name;
            $image->legend = strip_tags(Tools::substr($name, 0, 125).'');
            // Hook update triggered
            if (!$image->save()) {
                $this->errors[] = $this->l('Can\'t update the native object');
            }
        }
    }

    protected function processBulkMetadescriptiondesc()
    {
        foreach (Tools::getValue($this->table.'Box') as $idEverImg) {
            $everImg = new EverPsSeoImage(
                (int)$idEverImg
            );
            $image = new Image(
                (int)$everImg->id_seo_img,
                (int)$this->context->shop->id,
                (int)$everImg->id_seo_lang
            );

            $description = Db::getInstance()->getValue(
                'SELECT description FROM `'._DB_PREFIX_.'product_lang`
                WHERE id_product = '.pSQL($everImg->id_seo_product).'
                AND id_lang = '.pSQL($everImg->id_seo_lang)
            );

            if (!$description) {
                continue;
            }
            if (!$image->id_product) {
                continue;
            }

            $everImg->alt = $description;
            $image->legend = strip_tags(Tools::substr($description, 0, 125).'');
            // Hook update triggered
            if (!$image->save()) {
                $this->errors[] = $this->l('Can\'t update the native object');
            }
        }
    }

    protected function displayError($message, $description = false)
    {
        /**
         * Set error message and description for the template.
         */
        array_push($this->errors, $this->module->l($message), $description);

        return $this->setTemplate('error.tpl');
    }
}
