<?php
/**
 * Project : everpscontentseo
 * @author Team Ever
 * @link https://www.team-ever.com
 * @copyright Team Ever
 * @license   Tous droits réservés / Le droit d'auteur s'applique (All rights reserved / French copyright law applies)
 */

if (!defined('_PS_VERSION_')){
    exit;
}
require_once _PS_MODULE_DIR_.'everpscontentseo/classes/Everpscontentseomanufacturer.php';

class AdminEverpscontentseomanufacturersController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->display = 'SEO manufacturers';
        $this->meta_title = $this->l('SEO manufacturers');
        $this->table = 'everpscontentseo_manufacturers';
        $this->className = 'Everpscontentseomanufacturer';
        $this->context = Context::getContext();
        $this->identifier = "id_everpscontentseo_manufacturer";

        $this->_orderBy = 'id_everpscontentseo_manufacturer';
        $this->_orderWay = 'ASC';
        $this->_select = 'pl.name';

        $this->_join = '
        LEFT JOIN `'._DB_PREFIX_.'manufacturer` pl
        ON (
            pl.id_manufacturer = a.id_manufacturer
        )';

        $this->fields_list = array(
            'id_everpscontentseo_manufacturer' => array(
                'title' => $this->l('ID'),
                'align' => 'left',
                'width' => 25
            ),
            'name' => array(
                'title' => $this->l('Manufacturer'),
                'align' => 'left',
                'width' => 25
            ),
        );

        $this->colorOnBackground = true;

        parent::__construct();
    }

    protected function l($string, $class = null, $addslashes = false, $htmlentities = true)
    {
        return Translate::getModuleTranslation('everpscontentseo', $string, 'AdminEverredirectController');
    }

    public function initPageHeaderToolbar()
    {
        $this->page_header_toolbar_btn['new'] = array(
            'href' => self::$currentIndex . '&add' . $this->table . '&token=' . $this->token,
            'desc' => $this->l('Add new element'),
            'icon' => 'process-icon-new'
        );
        parent::initPageHeaderToolbar();
    }

    public function renderList()
    {
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->toolbar_title = $this->l('SEO Manufacturers');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected items'),
                'confirm' => $this->l('Delete selected items ?')
            ),
        );

        if (Tools::isSubmit('submitBulkdelete'.$this->table)) {
            $this->processBulkDelete();
        }
        if (Tools::isSubmit('submitBulkdisableSelection'.$this->table)) {
            $this->processBulkDisable();
        }
        if (Tools::isSubmit('submitBulkenableSelection'.$this->table)) {
            $this->processBulkEnable();
        }

        $lists = parent::renderList();
        $html=$this->context->smarty->fetch(_PS_MODULE_DIR_ . '/everpscontentseo/views/templates/admin/header.tpl');
        $html .= $lists;
        $html .= $this->context->smarty->fetch(_PS_MODULE_DIR_ . '/everpscontentseo/views/templates/admin/footer.tpl');

        return $html;
    }

    public function renderForm()
    {
        $manufacturers = Manufacturer::getManufacturers(
            false,
            true,
            false
        );
        // Building the Add/Edit form
        $this->fields_form = array(
            'tinymce' => true,
            'description' => $this->l('Manufacturer edition'),
            'submit' => array(
                'name' => 'save',
                'title' => $this->l('Save'),
                'class' => 'button pull-right'
            ),
            'input' => array(
                array(
                    'type' => 'select',
                    'label' => $this->l('Manufacturer'),
                    'required' => true,
                    'name' => 'id_manufacturer',
                    'lang' => false,
                    'options' => array(
                        'query' => $manufacturers,
                        'id' => 'id_manufacturer',
                        'name' => 'name'
                    )
                ),
                array(
                    'type' => 'textarea',
                    'label' => $this->l('Manufacturer content'),
                    'desc'      => $this->l('Leave empty for no use'),
                    'required' => true,
                    'name' => 'content',
                    'lang' => true,
                    'autoload_rte' => true,
                    'cols' => 60,
                    'rows' => 30
                ),
            )
        );
        return parent::renderForm();
    }

    public function postProcess()
    {
        if (Tools::getIsset('deleteeverpscontentseo_manufacturers')) {
            $everObj = new Everpscontentseomanufacturer(
                (int)Tools::getValue('id_everpscontentseo_manufacturer')
            );
            $everObj->delete();
        }
        if (Tools::isSubmit('save')) {
            $id = (int)Tools::getValue('id_everpscontentseo_manufacturer');

            $evermanufacturer = new Everpscontentseomanufacturer($id);

            $evermanufacturer->id_manufacturer = (int)Tools::getValue('id_manufacturer');

            foreach (Language::getLanguages(false) as $language) {
                $evermanufacturer->content[(int)$language['id_lang']] = Tools::getValue('content_'.(int)$language['id_lang']);
                $evermanufacturer->id_shop = (int)Context::getContext()->shop->id;
            }

            if (!$evermanufacturer->save()) {
                $this->errors[] = Tools::displayError('An error has occurred: Can\'t save the current object');
            }
        }
    }

    protected function processBulkDelete()
    {
        foreach (Tools::getValue($this->table.'Box') as $idEverObj) {
            $everObj = new Everpscontentseocategory((int)$idEverObj);

            if (!$everObj->delete()) {
                $this->errors[] = $this->l('An error has occurred: Can\'t delete the current object');
            }
        }
    }

    protected function processBulkDisable()
    {
        foreach (Tools::getValue($this->table.'Box') as $idEverObj) {
            $everObj = new Everpscontentseocategory((int)$idEverObj);
            if ($everObj->active) {
                $everObj->active = false;
            }

            if (!$everObj->save()) {
                $this->errors[] = $this->l('An error has occurred: Can\'t disable the current object');
            }
        }
    }

    protected function processBulkEnable()
    {
        foreach (Tools::getValue($this->table.'Box') as $idEverObj) {
            $everObj = new Everpscontentseocategory((int)$idEverObj);
            if (!$everObj->active) {
                $everObj->active = true;
            }

            if (!$everObj->save()) {
                $this->errors[] = $this->l('An error has occurred: Can\'t enable the current object');
            }
        }
    }
}
