{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    PrestaShop SA <contact@prestashop.com>
* @copyright 2007-2016 PrestaShop SA
* @license   http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
* International Registered Trademark & Property of PrestaShop SA
*}

<section class="panel widget" id="dashbypayment">
    <header class="panel-heading">
        <i class="icon-bar-chart"></i>
        {l s=' Turnover By Payment Method' mod='dashbypayment'}
    </header>
    <section id="dashbypaymentFrontFace">
        <div class="row dashbypaymentNav">
            <!-- DATEPICKER -->
            <div class="col-md-8 pull-left">
                {l s='From' mod='dashbypayment'}
                <input type="text" name="dashbypaymentDateStart" class="dashbypaymentDateInput" id="dashbypaymentDateStart" value="{$dashbypaymentStartDate|escape:'htmlall':'UTF-8'}" />
                {l s='to' mod='dashbypayment'}
                <input type="text" name="dashbypaymentDateEnd" class="dashbypaymentDateInput" id="dashbypaymentDateEnd" value="{$dashbypaymentEndDate|escape:'htmlall':'UTF-8'}" />
                <button class="btn btn-success" id="dashbypaymentSubmitDateRange">{l s='GO' mod='dashbypayment'}</button>
                <img src="{$dashbypaymentLoaderImgPath|escape:'htmlall':'UTF-8'}" id="dashbypaymentAjaxLoader">
            </div>
            <!-- NAV PILLS -->
            <nav id="dashbypaymentMenu" class="col-md-4 pull-right">
                <ul class="nav nav-pills pull-right" role="tablist">
                    <li class="active">
                        <a href="#dashbypayment_tab1" aria-controls="dashbypayment_tab1" data-toggle="tab">{l s='Table' mod='dashbypayment'}</a>
                    </li>
                    <li>
                        <a href="#dashbypayment_tab2" aria-controls="dashbypayment_tab2" data-toggle="tab">{l s='Pie' mod='dashbypayment'}</a>
                    </li>
                    <li>
                        <a href="#dashbypayment_tab3" aria-controls="dashbypayment_tab3" data-toggle="tab">{l s='Bars' mod='dashbypayment'}</a>
                    </li>
                </ul>
            </nav>
        </div>
        <div id="dashbypaymentPanel" class="tab-content panel">
            <div class="tab-pane active" id="dashbypayment_tab1">
                <table class="table table-responsive data_table">
                    <thead>
                        <tr>
                            <th class="text-center">{l s='Payment method' mod='dashbypayment'}</th>
                            <th class="text-center">{l s='Number of transactions' mod='dashbypayment'}</th>
                            <th class="text-center">{l s='Generated turnover' mod='dashbypayment'}</th>
                            <th class="text-center">{l s='Average shopping cart' mod='dashbypayment'}</th>
                            <th class="text-center">{l s='Percentage of transactions' mod='dashbypayment'}</th>
                            <th class="text-center">{l s='Percentage of turnover' mod='dashbypayment'}</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach from=$dashbypaymentBestPaymentMethod item=paymentMethod}
                        <tr>
                            <td class="text-center">{$paymentMethod.paymentMethod|escape:'htmlall':'UTF-8'}</td>
                            <td class="text-center">{$paymentMethod.nbTransac|escape:'htmlall':'UTF-8'}</td>
                            <td class="text-center">{$paymentMethod.generatedCA|escape:'htmlall':'UTF-8'}</td>
                            <td class="text-center">{$paymentMethod.AverageBasket|escape:'htmlall':'UTF-8'}</td>
                            <td class="text-center">{$paymentMethod.percentTransac|escape:'htmlall':'UTF-8'}</td>
                            <td class="text-center">{$paymentMethod.percentCA|escape:'htmlall':'UTF-8'}</td>
                        </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
            <div id="dashbypayment_tab2" class="tab-pane" id="dashbypayment_trigger_tab2" >
                <div id="placeholder_dashbypayment_pie" class="dashbypaymentFlotPlaceholder"></div>
                <p class="dashbypaymentTotalTurnover">{$dashbypaymentTotalTurnover|escape:'htmlall':'UTF-8'}</p>
            </div>
            <div id="dashbypayment_tab3" class="tab-pane" id="dashbypayment_trigger_tab3">
                <div id="placeholder_dashbypayment_bars" class="dashbypaymentFlotPlaceholder" ></div>
                <p class="dashbypaymentTotalTurnover">{$dashbypaymentTotalTurnover|escape:'htmlall':'UTF-8'}</p>
            </div>
        </div>
        <div id="dashbypaymentEmptyMessage">{$dashbypaymentEmptyMessage|escape:'htmlall':'UTF-8'}</div>
    </section>
    <section id="dashbypaymentBackFace" >
        <div class="row dashbypaymentNav" id="dashbypaymentFormSubmitFeedback">
            <!-- HERE GOES THE AJAX SUBMIT FEEDBACK-->
        </div>
    </section>
</section>

{literal}
<script type="text/javascript">
    var dashbypaymentDataPie                 = {/literal}{$dashbypaymentFlotPieData}{literal};
    var dashbypaymentHasOrders               = "{/literal}{$dashbypaymentHasOrders|escape:'htmlall':'UTF-8'}{literal}";
    var dashbypaymentCurrencySign            = "{/literal}{$dashbypaymentCurrencySign|escape:'htmlall':'UTF-8'}{literal}";
    var dashbypaymentBaseDir                 = "{/literal}{$dashbypaymentBaseDir|escape:'htmlall':'UTF-8'}{literal}";
    var dashbypaymentBarChartYAxisLabel      = "{/literal}{$dashbypaymentBarChartYAxisLabel|escape:'htmlall':'UTF-8'}{literal}";
    var dashbypaymentBarChartXAxisLabel      = "{/literal}{$dashbypaymentBarChartXAxisLabel|escape:'htmlall':'UTF-8'}{literal}";
    var dashbypaymentAdmin_module_ajax_url   = "{/literal}{$dashbypaymentController_url}{literal}";
    var dashbypaymentAdmin_module_controller = "{/literal}{$dashbypaymentController_name}{literal}";
</script>{/literal}
