
/**
 * 2007-2016 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2016 PrestaShop SA
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */

// Main Function
var Main = function () {

  /**
   ** Display save Button on collapse
   */
  var collapseStep = function (obj) {
    $id = $(obj).attr('href');
    a = $($id).attr('class');
    $($id).parents().find('.panel-footer').addClass('hide');
    $($id).parent().find('.panel-footer').removeClass('hide');
    $($id).parents().siblings().find('.in').removeClass('in').addClass('collapse');
    $($id).removeClass('in');
    a = $($id).attr('class');
  }

  /**
   ** Click Event
   */
  var runEvent = function () {

    // Click on Panel
    $('#modulecontent .tab-content h3 a').live('click', function (e) {
      e.preventDefault();
      var collapse = $(this).attr('data-toggle');
      if (typeof(collapse) !== "undefined" && collapse === 'collapse') {
        var id = $(this).attr('href');
        var is_collapse = false;

        $(this.attributes).each(function() {
          if (this.nodeName === 'class') {
            if(this.nodeValue === '') {
              is_collapse = true;
            }
          }
        });

        if ($(this).attr('class') === undefined) {
          is_collapse = true;
        }
      }
    });

    // Tab panel active
    $(".list-group-item").on('click', function() {
      var $el = $(this).parent().closest(".list-group").children(".active");
      if ($el.hasClass("active")) {
        $el.removeClass("active");
        $(this).addClass("active");
      }
    });
  };

  /**
   ** Custom Elements
   */
  var runCustomElement = function () {
    // Hide ugly toolbar
    $('table[class="table"]').each(function() {
      $(this).hide();
      $(this).next('div.clear').hide();
    });

    // Hide ugly multishop select
    if (typeof(_PS_VERSION_) !== 'undefined') {
      var version = _PS_VERSION_.substr(0,3);
      if(version === '1.5') {
        $('.multishop_toolbar').addClass("panel panel-default");
        $('.shopList').removeClass("chzn-done").removeAttr("id").css("display", "block").next().remove();
        cloneMulti = $(".multishop_toolbar").clone(true, true);
        $(".multishop_toolbar").first().remove();
        cloneMulti.find('.shopList').addClass('selectpicker show-menu-arrow').attr('data-live-search', 'true');
        cloneMulti.insertBefore("#modulecontent");
        // Copy checkbox for multishop
        cloneActiveShop = $.trim($('table[class="table"] tr:nth-child(2) th').first().html());
        $(cloneActiveShop).insertAfter("#tab_translation");
      }
    }

    // Show tooltip for helping merchant
    $('a').tooltip();
  };

  return {
    init: function () {
      runEvent();
      runCustomElement();
    }
  };
}();

// Load functions
$(window).load(function() {
  Main.init();
});