/**
 * 2007-2016 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2016 PrestaShop SA
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */

function getDefault(flot, ticks) {
  if (flot == "pie") {
    var dashbypaymentOptions = {
      series: {
        pie: {
          show: true,
          radius: 90,
        }
      },
      legend: {
        show: true,
      },
      tooltip: {
        show: true,
        content: "%s: %n"+dashbypaymentCurrencySign +" (%p.2%)",
        shifts: {
          x: 20,
          y: 0
        },
        defaultTheme: false
      },
      grid: {
        hoverable: true
      }
    };
  } else {
    var dashbypaymentOptions = {
      series: {
        bars: {
          show: true
        },
      },
      grid: {
        hoverable: true
      },
      bars: {
        align: "center",
        barWidth: 0.5
      },
      xaxis: {
        ticks: ticks,
        axisLabel: dashbypaymentBarChartXAxisLabel
      },
      yaxis: {
        axisLabel: dashbypaymentBarChartYAxisLabel
      }
    };
  }
  return dashbypaymentOptions;
}

$(document).ready(function() {
  $('#dashbypaymentEmptyMessage').hide();
  if (dashbypaymentDataPie == false) {
    $('#dashbypaymentMenu').hide();
  }
  // PIE CHARTS
  // Draw chart when the tab is clicked.
  // dashbypaymentDataPie variable is defined is dashboard_zone_two.tpl
  $('a[href="#dashbypayment_tab2"]').on('click', function() {
    setTimeout(function() {
      $.plot($("#placeholder_dashbypayment_pie"), dashbypaymentDataPie, getDefault('pie', null));
    }, 500);
  });

  // BAR CHARTS
  var ticks = [];
  var data = [];
  dashbypaymentDataPie.forEach(function(elem, index, array){
    ticks.push([index, elem.label]);
    data.push([index, elem.data]);
  });
  var DataSetBar = [
  {
    data: data,
    color: "#5482FF"
  }];

  $('a[href="#dashbypayment_tab3"]').on('click', function() {
    setTimeout(function() {
      $.plot($("#placeholder_dashbypayment_bars"), DataSetBar, getDefault('bar', ticks));
    }, 500);
  });

  // Handle hover event on bars
  var previous_point = null;
  $("#placeholder_dashbypayment_pie").on("plothover", function (event, pos, item) {
    if (!item) {
      return;
    }
  });
  $("#placeholder_dashbypayment_bars").on("plothover", function (event, pos, item) {
    if (item) {
      if (previousPoint != item.dataIndex) {
        previousPoint = item.dataIndex;
        $('#tooltip').remove();
        var x = item.datapoint[0];
        var y = item.datapoint[1] - item.datapoint[2];

        showTooltip(item.pageX, item.pageY, item.series.xaxis.ticks[x].label + ': ' + y + dashbypaymentCurrencySign);
      }
    } else {
        $('#tooltip').remove();
        previousPoint = null;
    }
  });
  function showTooltip(x, y, contents) {
    $('<div id="tooltip">' + contents + '</div>').css({
      position: 'absolute',
      display: 'none',
      top: y + 5,
      left: x + 20,
      border: '2px solid #4572A7',
      padding: '2px',
      size: '10',
      'border-radius': '6px 6px 6px 6px',
      'background-color': '#fff',
      opacity: 0.80
    }).appendTo("body").fadeIn(200);
  }
  // ---------------------
  // Button date go
  $('#dashbypaymentSubmitDateRange').on("click", function(){
    $('#dashbypaymentAjaxLoader').show();
    var dateStart = $('#dashbypaymentDateStart').val();
    var dateEnd = $('#dashbypaymentDateEnd').val();
    $.ajax({
      type: 'POST',
      dateType: 'json',
      url: dashbypaymentAdmin_module_ajax_url,
      data: {
        controller: dashbypaymentAdmin_module_controller,
        ajax: true,
        action: 'SetDates',
        dateStart: dateStart,
        dateEnd: dateEnd
      },
      success: function(data) {
        $('#dashbypaymentAjaxLoader').hide();
        //Table update
        var myVar = [];
        var dashbypaymentDataPie = [];

        try {
          myVar = $.parseJSON(data);
          $('#dashbypayment_tab1').html(myVar.resultTable);
          dashbypaymentDataPie = $.parseJSON(myVar.resultPie);
          if (dashbypaymentDataPie != false) {
            $.plot($("#placeholder_dashbypayment_pie"), dashbypaymentDataPie, getDefault('pie', null));
            $('#dashbypaymentMenu').show();
            $('#dashbypaymentPanel').show();
            $('#dashbypaymentEmptyMessage').hide();
          } else {
            $('#dashbypaymentMenu').hide();
            $('#dashbypaymentPanel').hide();
            $('#dashbypaymentEmptyMessage').show();
          }

          //Pie update
          $('a[href="#dashbypayment_tab2"]').on('click', function() {
            setTimeout(function() {if (dashbypaymentDataPie != false) {
              $.plot($("#placeholder_dashbypayment_pie"), dashbypaymentDataPie, getDefault('pie', null));
              $('#dashbypaymentMenu').show();
              $('#dashbypaymentPanel').show();
              $('#dashbypaymentEmptyMessage').hide();
            } else {
              $('#dashbypaymentMenu').hide();
              $('#dashbypaymentPanel').hide();
              $('#dashbypaymentEmptyMessage').show();
            }
            }, 500);
          });
        } catch (e) {
          // handling flot error with series
          return;
        }

        //Bars update
        var ticks = [];
        var data = [];
        dashbypaymentDataPie.forEach(function(elem, index, array){
          ticks.push([index, elem.label]);
          data.push([index, elem.data]);
        });
        var DataSetBar = [
        {
          data: data,
          color: "#5482FF"
        }];
        $.plot($("#placeholder_dashbypayment_bars"), DataSetBar, getDefault('bar', ticks));
        $('a[href="#dashbypayment_tab3"]').on('click', function() {
          setTimeout(function() {
            $.plot($("#placeholder_dashbypayment_bars"), DataSetBar, getDefault('bar', ticks));
          }, 500);
        });

        // Total turnover update :
        $('.dashbypaymentTotalTurnover').html(myVar.generatedCA);
      },
      error: function(err) {
        console.log(err);
        $('#dashbypaymentAjaxLoader').hide();
      }
    });
  });
  // ---------------------
});
 // Daterangepicker
  $(function() {
    var dateFormat = "yy-mm-dd",
    from = $( "#dashbypaymentDateStart" )
      .datepicker({
        dateFormat: dateFormat,
        defaultDate: "-1",
        changeMonth: true,
        changeYear: true
      })
    .on( "change", function() {
      to.datepicker( "option", "minDate", getDate( this ) );
    }),
    to = $( "#dashbypaymentDateEnd" )
      .datepicker({
        dateFormat: dateFormat,
        defaultDate: "+1w",
        changeMonth: true,
        changeYear: true
      })
    .on( "change", function() {
      from.datepicker( "option", "maxDate", getDate( this ) );
    });

    function getDate( element ) {
      var date;
      try {
        date = $.datepicker.parseDate( dateFormat, element.value );
      } catch( error ) {
        date = null;
      }
      return date;
    }
  });