<?php
/**
 * 2007-2016 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2016 PrestaShop SA
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */

class AdminDashbypaymentController extends ModuleAdminController
{
    public function ajaxProcessSetDates()
    {
        if (Tools::getIsset('dateStart') && Tools::getIsset('dateEnd')) {

            die($this->getData(Tools::getValue('dateStart'), Tools::getValue('dateEnd')));
        }
    }

    /**
    * getData get payment means statistics from ajax request
    *
    * @param  string $dateStart Date start of the interval which will be printed
    * @param  string $dateEnd   Date end of the intervale
    * @return json             statistics resluts
    */
    public function getData($startDate, $endDate)
    {
        $module = Module::getInstanceByName('dashbypayment');

        $return                 = array();
        $data                   = $module->getBestPaymentsMeans($startDate, $endDate);

        // Compute total turnover on all the categories
        $return['generatedCA']  = $module->getTotalTurnover($startDate, $endDate);

        $return['resultTable']  = $module->getResultTable($startDate, $endDate);
        $return['resultPie']    = $module->getFlotPieData($data);

        return Tools::jsonEncode($return);
    }
}
