/*
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author Buy-addons <contact@buy-addons.com>
*  @copyright  2007-2021 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

$(document).ready(function(){
	// tìm shipping cost element
	var ship_row=$("#shipping_table tbody tr");
	if(ship_row.length == 0) {
		ship_row=$("#orderShippingTabContent tbody tr").eq(0); // 1.7.7+
	}
	
	var ship_cost=ship_row.find("td").eq(4);
	var id_order_carrier=ship_row.find('input[name="id_order_carrier"]').attr("value");
	if (typeof id_order_carrier === "undefined") {
		// 1.7.0+
	  id_order_carrier = ship_row.find('a.edit_shipping_link').attr("data-id-order-carrier");
	}
	if (typeof id_order_carrier === "undefined") {
	  id_order_carrier = ship_row.find('a.js-update-shipping-btn').attr("data-order-carrier-id"); // 1.7.7+
	}
	//console.log(ship_cost);
	var icon_edit = '../img/admin/edit.gif';
	var disabled_edit = '../img/admin/disabled.gif';
	if (typeof baseAdminDir !== "undefined") {
	  icon_edit = baseAdminDir + icon_edit; // 1.7.7+
	  disabled_edit = baseAdminDir + disabled_edit; // 1.7.7+
	}
	
	
	var ship_cost_html='<span class="ship_cost_text">'+ship_cost.text()+'</span>'
					+'<form style="display: inline;" method="post" action="" id="shipping_cost_show">'
					+'<span class="shipping_cost_edit" style="display:none;">'
					+'	<input type="hidden" name="id_order_carrier" class="id_order_carrier" value="'+id_order_carrier+'">'
					+'	<input type="text" name="ship_cost_new" value="" class="ship_cost_new" />'
					+'	<input type="button" class="button" name="submitShippingCost" value="Update" onclick="return shipping_cost_update(this)">'
					+'</span>'
					+'<a href="#" onclick="return shipping_cost_show(this)" class="edit_shipping_cost_link"><img src="'+icon_edit+'" alt="Edit"></a>'
					+'<a href="#" onclick="return shipping_cost_cancel(this)" class="cancel_shipping_cost_link" style="display: none;"><img src="'+disabled_edit+'" alt="Cancel"></a>'
					+'</form>';
	ship_cost.html(ship_cost_html);
});
// click edit
function shipping_cost_show(object){
	$(object).parent().find(".edit_shipping_cost_link").hide();// an Icon edit
	$(object).parent().find(".shipping_cost_edit").show();// hien Form
	$(object).parent().find(".cancel_shipping_cost_link").show(); // hien Cancel Icon
	return false;
}
// Click Cancel
function shipping_cost_cancel(object){
	$(object).parent().find(".edit_shipping_cost_link").show();// hien Icon edit
	$(object).parent().find(".shipping_cost_edit").hide();// an Form
	$(object).parent().find(".cancel_shipping_cost_link").hide(); // an Cancel Icon
	return false;
}
// click update
function shipping_cost_update(object){
	var ship_cost_new= parseFloat($(object).parent().find(".ship_cost_new").val());
	if(ship_cost_new=="" || isNaN(ship_cost_new))
		return false;

	$.ajax({
			type: 'POST',
			url: customshipping_ajax_url,
			dataType : 'json',
			data: {
				'ajax': true,
				'customshipping_token': customshipping_token,
				'ship_cost_new': $(object).parent().find(".ship_cost_new").val(),
				'id_order_carrier': $(object).parent().find(".id_order_carrier").val(),
				'id_order': customshipping_id_order,
				'value': $('#variable_shipping_price').val(),
			},
			success: function(res) {
				//console.log(res);
				$(object).parent().parent().parent().find(".ship_cost_text").html(res.shipping_cost_tax_incl);
				// cap nhat Total shipping
				$("#total_shipping .amount").html(res.shipping_cost_tax_incl);
				$("#orderShippingTotal").html(res.shipping_cost_tax_incl); // 1.7.7
				// cap nhat Total Order
				$("#total_order .amount").html(res.total_paid_tax_incl);
				$("#orderTotal").html(res.total_paid_tax_incl);// 1.7.7
				// an form
				$(object).parent().parent().parent().find(".edit_shipping_cost_link").show();// hien Icon edit
				$(object).parent().parent().parent().find(".shipping_cost_edit").hide();// an Form
				$(object).parent().parent().parent().find(".cancel_shipping_cost_link").hide(); // an Cancel Icon
				
			},
		});
	return false;
}