<?php
/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2018 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class AdminRobotsGenController extends ModuleAdminController {

	public function __construct()
	{
		$this->bootstrap = true;
		$this->context = Context::getContext();
		$state_message = (int)Tools::getValue('success');
		$this->robots_file = _PS_ROOT_DIR_.'/robots.txt';
		$this->robots_url = _PS_BASE_URL_.__PS_BASE_URI__.'robots.txt';
		$message = '';
		$this->sitemap = _PS_ROOT_DIR_.DIRECTORY_SEPARATOR.$this->context->shop->id.'_index_sitemap.xml';
		$this->btn_title = file_exists($this->robots_file) ? 'Re-Generate' : 'Generate';
		if ($state_message == 1)
			$message = '<div class="alert alert-success"><button data-dismiss="alert" class="close" type="button">×</button>Robots.txt generated</div><br/>';
		elseif ($state_message == 2)
			$message = '<div class="alert alert-success"><button data-dismiss="alert" class="close" type="button">×</button>Robots.txt updated</div><br/>';
		$_html_generate = $message;
		$_html_generate .= file_exists($this->robots_file) ? '<p>You have a valid Robots.txt file.</p><br/><a href="'.$this->robots_url.'" target="_blank">'.$this->robots_url.'</a>' : '<p>Robots.txt was not found on your server, Please Generate. In case you already generated the file please make sure it has writable permissions.</p>';
		$_html = file_exists($this->robots_file) ? '<textarea class=" textarea-autosize" name="robot_data" style="word-wrap: break-word; min-height: 220px;">'.Tools::file_get_contents($this->robots_file).'</textarea>' : '<p>No Robots.txt found! Please generate.</p>';
		parent::__construct();
		$this->fields_options = array(
			'template' => array(
				'title' =>	$this->l('Generate Robots.txt'),
				'image' => '../img/admin/tab-tools.gif',
				'info' => $_html_generate,
				'submit' => array('title' => $this->btn_title, 'name' => 'submitGenRobot'),
				),
			'general' => array(
					'title' => $this->l('Edit Robots.txt'),
					'info' => $_html,
					'submit' => array('title' => 'Save', 'name' => 'submitSaverbt'),
					)
				);
	}

	public function postProcess()
	{
		$robots_txt_content = Tools::getValue('robot_data');
		if (Tools::isSubmit('submitGenRobot'))
			$this->generateRobotsFile();
		elseif (Tools::isSubmit('submitSaverbt'))
			$this->UpdateRobotsFile($robots_txt_content);

		parent::postProcess();
	}

	public function generateRobotsFile()
	{
		$this->robots_data = $this->getRobotsContent();
		if (!$write_fd = @fopen($this->robots_file, 'w'))
			$this->errors[] = sprintf(Tools::displayError('Cannot write into file: %s. Please check write permissions.'), $this->robots_file);
		else
		{
			fwrite($write_fd, "# robots.txt automaticaly generated by PrestaShop e-commerce open-source solution\n");
			fwrite($write_fd, "# http://www.prestashop.com - http://www.prestashop.com/forums\n");
			fwrite($write_fd, "# This file is to prevent the crawling and indexing of certain parts\n");
			fwrite($write_fd, "# of your site by web crawlers and spiders run by sites like Yahoo!\n");
			fwrite($write_fd, "# and Google. By telling these \"robots\" where not to go on your site,\n");
			fwrite($write_fd, "# you save bandwidth and server resources.\n");
			fwrite($write_fd, "# For more information about the robots.txt standard, see:\n");
			fwrite($write_fd, "# http://www.robotstxt.org/robotstxt.html\n");

			// User-Agent
			fwrite($write_fd, "User-agent: *\n");

			// Private pages
			if (count($this->robots_data['GB']))
			{
				fwrite($write_fd, "# Private pages\n");
				foreach ($this->robots_data['GB'] as $gb)
					fwrite($write_fd, 'Disallow: /*'.$gb."\n");
			}

			// Directories
			if (count($this->robots_data['Directories']))
			{
				fwrite($write_fd, "# Directories\n");
				foreach ($this->robots_data['Directories'] as $dir)
					fwrite($write_fd, 'Disallow: */'.$dir."\n");
			}

			// Files
			if (count($this->robots_data['Files']))
			{
				$languages = Language::getLanguages();
				fwrite($write_fd, "# Files\n");
				foreach ($this->robots_data['Files'] as $iso_code => $files)
					foreach ($files as $file)
						if (count($languages) > 1)
							fwrite($write_fd, 'Disallow: /*'.$iso_code.'/'.$file."\n");
						else
							fwrite($write_fd, 'Disallow: /'.$file."\n");
			}

			// Sitemap
			if (file_exists($this->sitemap) && filesize($this->sitemap))
			{
				fwrite($write_fd, "# Sitemap\n");
				$sitemap_filename = basename($this->sitemap);
				fwrite($write_fd, 'Sitemap: '.(Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').$_SERVER['SERVER_NAME'].__PS_BASE_URI__.$sitemap_filename."\n");
			}

			fclose($write_fd);

			$this->redirect_after = self::$currentIndex.'&success=1&token='.$this->token;
		}
	}

	public function getRobotsContent()
	{
		$tab = array();

		// Directories
		$tab['Directories'] = array('classes/', 'config/', 'download/', 'mails/', 'modules/', 'translations/', 'tools/');

		// Files
		$disallow_controllers = array(
			'addresses', 'address', 'authentication', 'cart', 'discount', 'footer',
			'get-file', 'header', 'history', 'identity', 'images.inc', 'init', 'my-account', 'order', 'order-opc',
			'order-slip', 'order-detail', 'order-follow', 'order-return', 'order-confirmation', 'pagination', 'password',
			'pdf-invoice', 'pdf-order-return', 'pdf-order-slip', 'product-sort', 'search', 'statistics','attachment', 'guest-tracking'
		);

		// Rewrite files
		$tab['Files'] = array();
		if (Configuration::get('PS_REWRITING_SETTINGS'))
		{
			$sql = 'SELECT ml.url_rewrite, l.iso_code
					FROM '._DB_PREFIX_.'meta m
					INNER JOIN '._DB_PREFIX_.'meta_lang ml ON ml.id_meta = m.id_meta
					INNER JOIN '._DB_PREFIX_.'lang l ON l.id_lang = ml.id_lang
					WHERE l.active = 1 AND m.page IN (\''.implode('\', \'', $disallow_controllers).'\')';
			if ($results = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql))
				foreach ($results as $row)
					$tab['Files'][$row['iso_code']][] = $row['url_rewrite'];
		}

		$tab['GB'] = array(
			'?orderby=','?orderway=','?tag=','?id_currency=','?search_query=','?back=','?n=',
			'&orderby=','&orderway=','&tag=','&id_currency=','&search_query=','&back=','&n='
		);

		foreach ($disallow_controllers as $controller)
			$tab['GB'][] = 'controller='.$controller;

		return $tab;
	}

	public function UpdateRobotsFile($robots_txt_content)
	{
		if (!$write = @fopen($this->robots_file, 'w'))
			$this->errors[] = sprintf(Tools::displayError('Cannot write into file: %s. Please check write permissions.'), $this->robots_file);
		else
			fwrite($write, $robots_txt_content);

		fclose($write);
		$this->redirect_after = self::$currentIndex.'&success=2&token='.$this->token;
	}
}

