{*
*
*
*    Advanced Custom Fields
*    Copyright 2018 Inno-mods.io
*
*    @author    Inno-mods.io
*    @copyright Inno-mods.io
*    @version   1.7
*    Visit us at http://www.inno-mods.io
*
*
*}
<div id="container" class="row">
  <div class="col-xs-12">
		{if $importSuccess}
			<div class="alert alert-success">{l s='Import has been completed successfully!' mod='advancedcustomfields'}</div>
		{/if}
    {if $errorMessage}
      <div class="alert alert-danger">
        {if $errorMessage == 'noCustomField'}
          {l s='You have not selected a custom field!' mod='advancedcustomfields'}
        {else if $errorMessage == 'noShops'}
          {l s='You have not selected any shops!' mod='advancedcustomfields'}
        {else if $errorMessage == 'noFile'}
          {l s='You have not uploaded a file!' mod='advancedcustomfields'}
        {/if}
      </div>
    {/if}
  </div>
  <div class="col-xs-12">
    <div class="panel">
      <div class="panel-heading">{l s='Import data for a custom field' mod='advancedcustomfields'}</div>
      <div class="panel-content">

        <form action="{$uri}&moduleController=ImportCustomField" method="POST" enctype="multipart/form-data" class="form-horizontal">
          <div class="row">
            <label class="col-lg-4"></label>
            <div class="col-lg-8">
              <div class="alert alert-info">
                <b>{l s='It is strongly recommended to backup your data before importing.' mod='advancedcustomfields'}</b>
                <br>
                {l s='For sample csvs, please click' mod='advancedcustomfields'} <a href="{$uri}&moduleController=ImportSamples">{l s='here' mod='advancedcustomfields'}</a>.
              </div>
            </div>
          </div>
          <div class="form-group">
            <label class="control-label col-lg-4">
              {l s='Choose the custom field you want to populate' mod='advancedcustomfields'}
            </label>
            <div class="col-lg-8">
              <select name="id_custom_field" class="fixed-width-xl">
  							<option value="0">...</option>
                {foreach from=$customFields item=customField}
                  {if $customField['type'] != 'image'}
                    <option value="{$customField['id_custom_field']}">{$customField['name']} ({$customField['technical_name']})</option>
                  {/if}
                {/foreach}
  						</select>
            </div>
          </div>
          <div class="form-group">
            <label class="control-label col-lg-4">
              {l s='Choose the file that contains your data' mod='advancedcustomfields'}
            </label>
            <div class="col-lg-8">
              <input id="file" type="file" name="file" class="hide">
              <div class="dummyfile input-group">
                <span class="input-group-addon"><i class="icon-file"></i></span>
                <input id="file-name" type="text" name="file" readonly="">
                <span class="input-group-btn">
                  <button id="file-selectbutton" type="button" name="submitAddAttachments" class="btn btn-default">
                    <i class="icon-folder-open"></i> {l s='Add file' mod='fbpixelcatalog'}
                  </button>
                </span>
              </div>
            </div>
            <script type="text/javascript">
              $(document).ready(function(){
                $('#file-selectbutton').click(function(e) {
                  $('#file').trigger('click');
                });

                $('#file-name').click(function(e) {
                  $('#file').trigger('click');
                });

                $('#file').change(function(e) {
                  if ($(this)[0].files !== undefined)
                  {
                    var files = $(this)[0].files;
                    var name  = '';

                    $.each(files, function(index, value) {
                      name += value.name+', ';
                    });

                    $('#file-name').val(name.slice(0, -2));
                  }
                  else // Internet Explorer 9 Compatibility
                  {
                    var name = $(this).val().split(/[\\/]/);
                    $('#file-name').val(name[name.length-1]);
                  }
                });
              });
            </script>
          </div>
          <div class="form-group">
            <label class="control-label col-lg-4">
              {l s='Delete previous content for the specific custom field' mod='advancedcustomfields'}
            </label>
            <div class="col-lg-8">
              <span class="switch prestashop-switch fixed-width-lg">
  							<input type="radio" name="delete-previous" id="active_on" value="1">
  							<label for="active_on">Yes</label>
  							<input type="radio" name="delete-previous" id="active_off" value="0" checked="checked">
  							<label for="active_off">No</label>
  							<a class="slide-button btn"></a>
  						</span>
              <p class="help-block">{l s='Previous content for the custom field is going to be permanently deleted! No rollback is possible!' mod='advancedcustomfields'}</p>
            </div>
          </div>
          <div class="form-group">
          	<label class="control-label col-lg-4">
          		{l s='Apply the action to the following shops:' mod='advancedcustomfields'}
          	</label>
          	<div class="col-lg-8">
          		<div class="row">
        				<div class="col-lg-6">
        					<table class="table table-bordered">
        						<thead>
        							<tr>
        								<th class="fixed-width-xs">
        									<span class="title_box">
        										<input type="checkbox" name="checkme" id="checkme" onclick="checkDelBoxes(this.form, 'shops[]', this.checked)">
        									</span>
        								</th>
        								<th class="fixed-width-xs"><span class="title_box">{l s='ID' mod='advancedcustomfields'}</span></th>
        								<th>
        									<span class="title_box">
        										{l s='Shop name' mod='advancedcustomfields'}
        									</span>
        								</th>
        							</tr>
        						</thead>
          					<tbody>
                      {foreach from=$shops item=shop}
            						<tr>
            							<td>
            								<input type="checkbox" name="shops[]" class="groupBox" id="shops_{$shop['id_group']}" value="{$shop['id_group']}">
            							</td>
            							<td>{$shop['id_group']}</td>
            							<td>
            								<label for="shops_1">{$shop['name']}</label>
            							</td>
            						</tr>
                      {/foreach}
          					</tbody>
          				</table>
          			</div>
          		</div>
          		<p class="help-block">
          			{l s='Mark all the shops for which you want the action to apply.' mod='advancedcustomfields'}
          		</p>
          	</div>
          </div>
          <div class="form-group">
            <label class="control-label col-lg-4"></label>
            <div class="col-lg-8">
              <button type="submit" class="btn btn-primary" id="import-custom-field">{l s='Import' mod='advancedcustomfields'}</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
