/**
*
*
*    Advanced Custom Fields
*    Copyright 2018 Inno-mods.io
*
*    @author    Inno-mods.io
*    @copyright Inno-mods.io
*    @version   1.7
*    Visit us at http://www.inno-mods.io
*
*
**/
(function($) {
  "use strict";
  $(document).ready(function(){
    // run once on load
    showLocationHooks($('#advancedcustomfields #location').val());

    // init an on change event
    $('#advancedcustomfields #location').change(function(){
        // show location hooks
        showLocationHooks($(this).val());
    });

    // showLocationHooks
    function showLocationHooks(location)
    {
      // for product
      if (location == 'product'){
        // if product page v2 is activated
        if (productPageV2 == true){
          // show
          $('.form-group.admin-product-tab-option').show();
          $('.form-group.admin-product-add-after-option').show();
          // hide
          $('.form-group.admin-product-hook-option').hide();
        } else {
          // hide
          $('.form-group.admin-product-tab-option').hide();
          $('.form-group.admin-product-add-after-option').hide();
          // show
          $('.form-group.admin-product-hook-option').show();
        }
        // show
        $('.form-group.display-frontend-options').show();
        $('.form-group.type-admin-form-option').show();
        // hide
        $('.form-group.required-option').hide();
        $('.form-group.editable-frontend-option').hide();
        $('.form-group.type-frontend-form-option').hide();
        $('.form-group.type-admin-customer-form-option').hide();
        // trigger a change in the field type dropdwon
        $('#type_admin_form').trigger('change');
      }
      // for category
      if (location == 'category'){
        // show
        $('.form-group.required-option').show();
        $('.form-group.display-frontend-options').show();
        $('.form-group.type-admin-form-option').show();
        // hide
        $('.form-group.editable-frontend-option').hide();
        $('.form-group.admin-product-hook-option').hide();
        $('.form-group.admin-product-tab-option').hide();
        $('.form-group.admin-product-add-after-option').hide();
        $('.form-group.type-frontend-form-option').hide();
        $('.form-group.type-admin-customer-form-option').hide();
        // trigger a change in the field type dropdwon
        $('#type_admin_form').trigger('change');
      }
      // for customer
      if (location == 'customer'){
        // hide
        $('.form-group.admin-product-hook-option').hide();
        $('.form-group.admin-product-tab-option').hide();
        $('.form-group.admin-product-add-after-option').hide();
        $('.form-group.type-admin-form-option').hide();
        $('.form-group.translatable-option').hide();
        $('#translatable_on').prop("checked", false);
        $('#translatable_off').prop("checked", true);
        // show
        $('.form-group.required-option').show();
        $('.form-group.editable-frontend-option').show();

        // show field types according to editable option
        if ($('#advancedcustomfields #editable_frontend_on').is(':checked')){
          $('.form-group.type-admin-form-option').hide();
          $('.form-group.type-frontend-form-option').show();
          $('.form-group.type-admin-customer-form-option').hide();
        }
        if ($('#advancedcustomfields #editable_frontend_off').is(':checked')){
          $('.form-group.type-admin-form-option').hide();
          $('.form-group.type-frontend-form-option').hide();
          $('.form-group.type-admin-customer-form-option').show();
        }
      }

    }

    // get field types if editable option changed
    $('#advancedcustomfields input[name=editable_frontend]').click(function(){
      // if editable on
      if ($('#advancedcustomfields input[name=editable_frontend]:checked').val() == 1){
        $('.form-group.type-admin-form-option').hide();
        $('.form-group.type-admin-customer-form-option').hide();
        $('.form-group.type-frontend-form-option').show();
      }
      // if editable off
      if ($('#advancedcustomfields input[name=editable_frontend]:checked').val() == 0){
        $('.form-group.type-admin-form-option').hide();
        $('.form-group.type-frontend-form-option').hide();
        $('.form-group.type-admin-customer-form-option').show();
      }
    });







    // run once on load
    if ($('#advancedcustomfields #type_frontend_form').is(":visible")){
        showFieldOptions($('#advancedcustomfields #type_frontend_form').val());
    }
    if ($('#advancedcustomfields #type_admin_form').is(":visible")){
        showFieldOptions($('#advancedcustomfields #type_admin_form').val());
    }
    if ($('#advancedcustomfields #type_admin_form_customer').is(":visible")){
        showFieldOptions($('#advancedcustomfields #type_admin_form_customer').val());
    }

    // init an on change event
    $('#advancedcustomfields #type_admin_form').change(function(){
        // show location hooks
        showFieldOptions($(this).val());
    });
    // init an on change event
    $('#advancedcustomfields #type_frontend_form').change(function(){
        // show location hooks
        showFieldOptions($(this).val());
    });
    // init an on change event
    $('#advancedcustomfields #type_admin_form_customer').change(function(){
        // show location hooks
        showFieldOptions($(this).val());
    });

    // showFieldOptions
    function showFieldOptions(fieldType)
    {
      // translatable option
      if (fieldType == 'text' || fieldType == 'textarea' || fieldType == 'editor'){
        if ($('#location').val()=='customer'){
          $('.form-group.translatable-option').hide();
        } else {
          $('.form-group.translatable-option').show();
        }
      } else {
        $('.form-group.translatable-option').hide();
      }
      // available & default values options
      if (fieldType == 'checklist' || fieldType == 'select' || fieldType == 'radio'){
        $('.form-group.available-values-option').show();
        $('.form-group.default-value-option').show();
      } else {
        $('.form-group.available-values-option').hide();
        $('.form-group.default-value-option').hide();
      }
      // allow empty option for select fields
      if (fieldType == 'select'){
        $('.form-group.allow-empty-select-option').show();
      } else {
        $('.form-group.allow-empty-select-option').hide();
      }

      // default & default values options
      if (fieldType == 'checkbox' || fieldType == 'switch'){
        $('.form-group.default-status-option').show();
      } else {
        $('.form-group.default-status-option').hide();
      }
      // default & default values options
      if (fieldType == 'checkbox'){
        $('.form-group.single-label-option').show();
      } else {
        $('.form-group.single-label-option').hide();
      }
      // default status option
      if($('#advancedcustomfields #location').val()!='product'){
        if (fieldType == 'switch'){
          $('.form-group.required-option').hide();
        } else {
          $('.form-group.required-option').show();
        }
      }
    }



    /*
    * upload image for product edit screen
    */
    $('body').on("change", ".acf-image .acf-image-input",function(e){
      e.preventDefault();
      // get custom field wrapper
      var imageWrapper = $(this).closest('.acf-image').attr('id');
      // check that we are in an idle condition
      if (!$("#"+imageWrapper).hasClass('uploading')){
        // add an uploading status
        $("#"+imageWrapper).addClass('uploading');
        // prepare ajax request options
        var image = $(this).prop("files")[0];
        var formData = new FormData();
        formData.append("file", image);
        formData.append("name", $(this).closest('.acf-image').attr('data-custom-field'));
        formData.append("id", $('#form_id_product').val());
        formData.append("ajax", 1);
        // make the ajax request
        $.ajax({
                type: 'post',
                url: AcfUploadController,
                data : formData,
                contentType: false,
                cache: false,
                processData: false,
                dataType: 'json',
                success : function(response){
                    // show thumbnail
                    $("#"+imageWrapper+" figure .currentImage").html(response.image);
                    // show filesize
                    $("#"+imageWrapper+" figure .fileSize").html(response.fileSize);
                    // display thumbnail wrapper
                    $("#"+imageWrapper+" figure").show();
                    // remove uploading class
                    $("#"+imageWrapper).removeClass('uploading');
                }
        });
      }
    });


    /*
    * delete image for product edit screen (for product page v1)
    */
    $('body').on("click", ".deleteProductImage",function(e){
      e.preventDefault();
      // get custom field wrapper
      var imageWrapper = $(this).closest('.acf-image').attr('id');
      // make the ajax delete request
      $.ajax({
              type: 'get',
              url: AcfDeleteProductImageController,
              data: {
                    name: $(this).closest('.acf-image').attr('data-custom-field'),
                    objectId: $('#form_id_product').val()
                    },
              success : function(response){
                    // unset thumbnail
                    $("#"+imageWrapper+" figure .currentImage").html('');
                    // unset filesize
                    $("#"+imageWrapper+" figure .fileSize").html('0');
                    // hide wrapper
                    $("#"+imageWrapper+" figure").hide();
                  }
              });
    });


    /*
    * delete image for category edit screen
    */
    $('body').on("click", ".deleteImage",function(e){
      e.preventDefault();
      // get thumbnail wrapper
      var thumbnailId = $(this).closest('figure').attr('id');
      // make the ajax request
      $.ajax({
              type: 'get',
              url: AcfDeleteImageController,
              data: {
                    name: $('#'+thumbnailId).attr('data-custom-field'),
                    objectId: $('#'+thumbnailId).attr('data-object-id')
                    },
              success : function(response){
                    // assign label to the input (applicable only in categories admin page)
                    $('#category_'+$('#'+thumbnailId).attr('data-custom-field')).closest('.form-group').find('.form-control-label').html($('#'+thumbnailId).attr('data-custom-field-label'));
                    // remove thumbnail (for both categories and product page v2)
                    $('#'+thumbnailId).closest('.form-group').remove();
                  }
              });
    });








    /*
    * update 'add after' based on selected tab
    */
    $('#advancedcustomfields #product_tab').change(function(){

        // options for 'add after'
        var addAfterOptions = {
                            'description' : {
                                              0 : {
                                                    'id'   : 'images',
                                                    'name' : 'Images'
                                                  },
                                              1 : {
                                                    'id'   : 'description_short',
                                                    'name' : 'Description short'
                                                  },
                                              2 : {
                                                    'id'   : 'description',
                                                    'name' : 'Description'
                                                  },
                                              3 : {
                                                    'id'   : 'categories',
                                                    'name' : 'Categories'
                                                  },
                                              4 : {
                                                    'id'   : 'manufacturer',
                                                    'name' : 'Manufacturer'
                                                  },
                                              5 : {
                                                    'id'   : 'related_products',
                                                    'name' : 'Related products'
                                                  },
                                            },
                            'details' : {
                                          0 : {
                                                'id'   : 'references',
                                                'name' : 'References'
                                              },
                                          1 : {
                                                'id'   : 'features',
                                                'name' : 'Features'
                                              },
                                          2 : {
                                                'id'   : 'attachments',
                                                'name' : 'Attachments'
                                              },
                                          3 : {
                                                'id'   : 'condition',
                                                'name' : 'Condition'
                                              },
                                          4 : {
                                                'id'   : 'customizations',
                                                'name' : 'Customizations'
                                              },
                                        },
                            'shipping' : {
                                          0 : {
                                                'id'   : 'dimensions',
                                                'name' : 'Dimensions'
                                              },
                                          1 : {
                                                'id'   : 'delivery_time_notes',
                                                'name' : 'Delivery time'
                                              },
                                          2 : {
                                                'id'   : 'additional_shipping_cost',
                                                'name' : 'Shipping fees'
                                              },
                                          3 : {
                                                'id'   : 'carriers',
                                                'name' : 'Carriers'
                                              },
                                        },
                            'pricing' : {
                                          0 : {
                                                'id'   : 'retail_price',
                                                'name' : 'Retail price'
                                              },
                                          1 : {
                                                'id'   : 'wholesale_price',
                                                'name' : 'Wholesale price'
                                              },
                                          2 : {
                                                'id'   : 'unit_price',
                                                'name' : 'Unit price'
                                              },
                                          3 : {
                                                'id'   : 'summary',
                                                'name' : 'Summary'
                                              },
                                          4 : {
                                                'id'   : 'on_sale',
                                                'name' : 'On sale'
                                              },
                                          5 : {
                                                'id'   : 'specific_prices',
                                                'name' : 'Specific prices'
                                              },
                                          6 : {
                                                'id'   : 'priority_management',
                                                'name' : 'Priority management'
                                              },
                                        },
                            'seo' : {
                                      1 : {
                                            'id'   : 'serp',
                                            'name' : 'Search engine result preview'
                                          },
                                      2 : {
                                            'id'   : 'meta_title',
                                            'name' : 'Meta title'
                                          },
                                      3 : {
                                            'id'   : 'meta_description',
                                            'name' : 'Meta description'
                                          },
                                      4 : {
                                            'id'   : 'link_rewrite',
                                            'name' : 'Link rewrite'
                                          },
                                      5 : {
                                            'id'   : 'redirect_option',
                                            'name' : 'Redirect option'
                                          },
                                      6 : {
                                            'id'   : 'tags',
                                            'name' : 'Tags'
                                          },
                                    },
                            'options' : {
                                          0 : {
                                                'id'   : 'visibility',
                                                'name' : 'Visibility'
                                              },
                                          1 : {
                                                'id'   : 'suppliers',
                                                'name' : 'Suppliers'
                                              },
                                          2 : {
                                                'id'   : 'product_suppliers',
                                                'name' : 'Product suppliers'
                                              },
                                        }
                            };

        // init an empty var
        var html = '';

        // get options to show
        var optionsToShow = addAfterOptions[$(this).find("option:selected").val()];

        // loop through options
        for (let i = 0; i < Object.keys(optionsToShow).length; i++) {
          // add option
          html += '<option value="'+optionsToShow[i]['id']+'">'+optionsToShow[i]['name']+'</option>';
        }

        // set new options
        $('#advancedcustomfields #add_after').html(html);
    });


  });
})(jQuery);
