<?php
/**
 * pm_advancedcookiebanner
 *
 * @author    Presta-Module.com <support@presta-module.com> - http://www.presta-module.com
 * @copyright Presta-Module - http://www.presta-module.com
 * @license   see file: LICENSE.txt
 *
 *           ____     __  __
 *          |  _ \   |  \/  |
 *          | |_) |  | |\/| |
 *          |  __/   | |  | |
 *          |_|      |_|  |_|
 */

if (!defined('_PS_VERSION_')) {
    exit;
}
class pm_advancedcookiebannerset_cookieModuleFrontController extends ModuleFrontController
{
    public $ajax = true;
    public $display_header = false;
    public $display_footer = false;
    public $display_column_left = false;
    public $display_column_right = false;
    public function init()
    {
        parent::init();
        header('X-Robots-Tag: noindex, nofollow', true);
        $this->ajax = true;
    }
    public function postProcess()
    {
        if (!$this->isTokenValid()) {
            die;
        }
    }
    public function displayAjax()
    {
        if (AcbCookie::exists()) {
            die;
        }
        $dbConsent = null;
        if (Tools::getIsset('consentData')) {
            $consentData = Tools::getValue('consentData');
            $consentData = AcbCookie::getValidatedConsentData($consentData);
            $analyticsModules = $this->module->getAnalyticsModulesList();
            $marketingModules = $this->module->getMarketingModulesList();
            $categorizedModules = array_unique(array_merge($analyticsModules, $marketingModules));
            $hashedModulesList = $this->module->getCachedHashedModulesList();
            $matchedModules = [];
            $rewrittenConsentData = [];
            foreach ($categorizedModules as $module) {
                $moduleHash = array_search($module, $hashedModulesList);
                if (is_null($moduleHash)) {
                    $moduleInstance = Module::getInstanceByName($module);
                    if (!Validate::isLoadedObject($moduleInstance)) {
                        continue;
                    }
                    $moduleHash = 'acb-' . Tools::hashIV($moduleInstance->id);
                }
                if (in_array($moduleHash, $consentData)) {
                    $matchedModules[] = $module;
                    $rewrittenConsentData[] = $moduleHash;
                }
            }
            AcbCookie::setConsentData(array_unique($rewrittenConsentData));
            $dbConsent = json_encode(array_unique($matchedModules));
        } else {
            $consentLevel = (int)Tools::getValue('consentLevel', 0);
            if ($consentLevel < 0 && $consentLevel > 3) {
                $consentLevel = 0;
            }
            AcbCookie::setConsentLevel($consentLevel);
            $dbConsent = $consentLevel;
        }
        $context = Context::getContext();
        $idGuest = $context->customer->id_guest;
        if (empty($idGuest)) {
            Guest::setNewGuest($context->cookie);
            $idGuest = $context->cookie->id_guest;
        }
        $res = Db::getInstance()->insert('pm_advancedcookiebanner_consent', [
            'id_customer' => (int)$context->customer->id,
            'id_guest' => (int)$idGuest,
            'consent' => $dbConsent,
            'date_add' => date('Y-m-d H:i:s'),
        ]);
        if (!$res) {
            die(json_encode([
                'error' => true,
            ]));
        }
        die;
    }
    public function initContent()
    {
    }
}
