{*
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<div class="panel">
	<h3><i class="icon icon-tags"></i> {l s='Stock watch system' mod='Stockwatchsystem'}</h3>
	<p>
		Ce module a pour but de surveiller l'etat du stock d'une boutique Prestashop. Il effectue la somme des mouvement
		de stock par produit et compare les résultats obtenus avec les informations contenue dans la table
		ps_stock_available.
	</p>

	<p>
		Pour effectuer une analyse manuelle, se rendre dans le répertoire racine de la boutique et exécuter la commande suivante : <br />
		<code>php bin/console stock-watch:analyse</code>
	</p>

	<p>
		Pour programmer une synchronisation automatique vous devez définir une tâche CRON appelant la commande suivante : <br />
		<code>php /var/www/ma-boutique/bin/console stock-watch:analyse</code>
	</p>

	<p>
		Pour lancer une synchronisation manuelle, veuillez cliquer sur le bouton suivant : <br />
		<a data-toggle="modal" data-target="#moduleTradLangSelect2" class="btn btn-primary" href="#">
			Analyser
		</a>
	</p>
</div>

<div class="panel">
	<h3><i class="icon icon-tags"></i> {l s='Documentation' mod='Stockwatchsystem'}</h3>
	<p>
		La documentation du module est disponible à l'adresse suivante :
		<ul>
			<li><a href="{$base_dir}/modules/Stockwatchsystem/readme.md">Français</a></li>
		</ul>
	</p>
</div>

<!-- Modal -->
<div class="modal fade" id="moduleTradLangSelect2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title" id="myModalLabel">Paramétrage de l'analyse</h4>
			</div>

			<form action="{$analyse_link}" method="POST" target="_blank">
				<div class="modal-body">
					<label class="control-label col-lg-4">
						Date de début mouvement
					</label>

					<div class="input-group col-lg-4">
						<input id="start_date" name="start_date" class="form-control" type="date">
						<span class="input-group-addon">
							<i class="icon-calendar-empty"></i>
						</span>
					</div>

					<br />

					<label class="control-label col-lg-4">
						Date de fin mouvement
					</label>

					<div class="input-group col-lg-4">
						<input id="end_date" name="end_date" class="form-control" type="date">
						<span class="input-group-addon">
							<i class="icon-calendar-empty"></i>
						</span>
					</div>
				</div>

				<div class="modal-footer">
					<button id="truc" type="submit" class="btn btn-primary">Exécuter</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
				</div>
			</form>
		</div>
	</div>
</div>
