<?php

namespace Cyllene\Stockwatchsystem\Controller;

use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Component\HttpFoundation\Response;

use Stockwatchsystem\lib\StockWatch;
use Stockwatchsystem\lib\MailService;

class StockWatchSystemController extends FrameworkBundleAdminController
{
    const DS           = DIRECTORY_SEPARATOR;
    const DATE_PATTERN = '/^[0-9]{4}-[0-9]{2}-[0-9]{2}$/';

    /**
     * Undocumented function
     *
     * @return void
     */
    public function analyseAction()
    {
        // Récupération de la configuration de la BDD.
        $basePath = dirname(dirname(dirname(dirname(dirname(dirname(__FILE__)))))) . self::DS . 'app' . self::DS . 'config';
        $config   = include $basePath . self::DS . 'parameters.php';
        $config   = $config['parameters'];

        // Ouverture d'une connexion à la BDD.
        $dbh = new \PDO("mysql:host={$config['database_host']};dbname={$config['database_name']};charset=UTF8", $config['database_user'], $config['database_password']);

        // Récupération des dates
        $options = [
            'options' => ['regexp' => self::DATE_PATTERN],
            'flags'   => FILTER_NULL_ON_FAILURE
        ];

        $startDate = filter_input(INPUT_POST, 'start_date', FILTER_VALIDATE_REGEXP, $options);
        $endDate   = filter_input(INPUT_POST, 'end_date', FILTER_VALIDATE_REGEXP, $options);

        // Vérification du stock.
        $stockWatch = new StockWatch($dbh);
        $stockWatch->computeQteMvt($startDate, $endDate);

        return $this->render('@Modules/Stockwatchsystem/views/templates/admin/analyse.html.twig', [
            'title'    => 'Analyse des stocks',
            'products' => $stockWatch->getProductsWarnningList()
        ]);
    }
}
