<?php

namespace Cyllene\Stockwatchsystem\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

use Stockwatchsystem\lib\StockWatch;
use Stockwatchsystem\lib\MailService;

/**
 * Undocumented class
 */
class AnalyseCommand extends Command
{
    const DS = DIRECTORY_SEPARATOR;

    protected static $name = 'stock-watch:analyse';

    protected $dateStart    = null;
    protected $productsList = '';

    protected function configure()
    {
        $this
            ->setName('stock-watch:analyse')
            ->setDescription('Analyse l\'état des stocks à la recherche d\incohérences entre les mouvements de produits et les valeurs des stocks');
    }

    /**
     * Exécution de la commande.
     *
     * @param InputInterface    $input
     * @param OutputInterface   $output
     *
     * @return void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        // Récupération de la configuration de la BDD.
        $basePath = dirname(dirname(dirname(dirname(dirname(__FILE__))))) . self::DS . 'app' . self::DS . 'config';
        $config   = include $basePath . self::DS . 'parameters.php';
        $config   = $config['parameters'];

        // Ouverture d'une connexion à la BDD et récuperation de la config.
        $dbh = new \PDO(
            "mysql:host={$config['database_host']};dbname={$config['database_name']}",
            $config['database_user'],
            $config['database_password']
        );

        $this->getAppConfig($dbh);

        // Vérification du stock.
        $stockWatch = new StockWatch($dbh);
        $stockWatch->computeQteMvt($this->dateStart, null, $this->productsList);

        // Envoie du mail.
        $mailService = new MailService($dbh);
        $mailService->sendMail($stockWatch->getProductsWarnningList());
    }

    /**
     * Undocumented function
     *
     * @param [type] $dbh
     *
     * @return void
     */
    protected function getAppConfig($dbh)
    {
        $query = "SELECT * FROM ps_configuration WHERE name LIKE 'STOCKWATCHSYSTEM%';";

        foreach($dbh->query($query) as $entry) {
            switch($entry['name']) {
                case 'STOCKWATCHSYSTEM_DATE_MVT':
                    $this->dateStart = $entry['value'];
                    break;

                case 'STOCKWATCHSYSTEM_PRODUCTS_LIST':
                    $this->productsList = $entry['value'];
                    break;

                default:
                    break;
            }
        }
    }
}
