const mainModal = document.querySelector('#mainmodal');
const modalBody = mainModal.querySelector('.modal-card-body');
const modalTitle = mainModal.querySelector('.modal-card-title');
document.addEventListener('DOMContentLoaded', () => {
  // Functions to open and close a modal
  function openModal($el) {
    $el.classList.add('is-active');
  }

  function closeModal($el) {
    $el.classList.remove('is-active');
  }

  function closeAllModals() {
    (document.querySelectorAll('.modal') || []).forEach(($modal) => {
      closeModal($modal);
    });
  }

  // Add a click event on buttons to open a specific modal
  (document.querySelectorAll('.js-modal-trigger') || []).forEach(($trigger) => {
    const modal = $trigger.dataset.target;
    const $target = document.getElementById(modal);

    $trigger.addEventListener('click', () => {
      openModal($target);
    });
  });

  // Add a click event on various child elements to close the parent modal
  (document.querySelectorAll('.modal-background, .modal-close, .modal-card-head .delete, .modal-card-foot .button') || []).forEach(($close) => {
    const $target = $close.closest('.modal');

    $close.addEventListener('click', () => {
      closeModal($target);
    });
  });

  // Add a keyboard event to close all modals
  document.addEventListener('keydown', (event) => {
    if (event.key === "Escape") {
      closeAllModals();
    }
  });
  // Link to customer account
  const linkCustomerBtns = document.querySelectorAll('button[data-action="linkCustomer"]');

  // Délégation du click
  document.body.addEventListener('click', function (event) {
    const target = event.target;
    // Link au compte client
    if (event.target.matches('.button[data-action="linkCustomer"], .button[data-action="linkCustomer"] *')) {
      // alert('clicked');
      openModal(mainModal);
      const container = mainModal.querySelector('.modal-card-body');
      const affaireId = event.target.dataset.affaireid;
      const customerId = event.target.dataset.customerid;
      fetch('./utils/linkCustomer.php?affaireId=' + affaireId + '&customerId=' + customerId)
        .then(response => response.text())
        .then(html => {
          container.innerHTML = html;
          document.querySelector('.modal-card-title').textContent = "Affaire liée au client";
        })
        .catch(error => console.error('Error loading content:', error));
      // });
    }
    // editable cells
    if (event.target.matches('.editable')) {
      closeLiveEdit();
      const previousValue = target.textContent;
      const dbField = target.dataset.dbfield;
      const affaireId = event.target.closest('tr').dataset.affaireid;
      target.innerHTML = `<form method="POST" action="updateTextField.php"class="columns is-vcentered" data-previousValue="${previousValue}">
      <div class="field">      
      <input type="hidden" name="dbfield" id="dbfield" value="${dbField}">   
      <input type="hidden" name="affaireid" id="affaireid" value="${affaireId}">             
                    <div class="control">
                        <input class="input" type="text" placeholder="entrer" name="content" id="content" value=${previousValue}>
                    </div>
                </div>
                <div>
                <button  class="button is-small is-warning" data-action="closeLiveEdit"><i class="fas fa-times"></i></button>
                <button type="submit" class="button is-small is-success"><i class="fas fa-check"></i></button>
                </div>
                </form>`;


    };
    // Show content in modal
    if (target.matches('.fullContentModal')) {
      openModal(mainModal);
      const container = mainModal.querySelector('.modal-card-body');
      document.querySelector('.modal-card-title').textContent = target.dataset.title;
      // })
      container.innerHTML = `<textarea class="textarea" >${target.textContent}</textarea><button class="button is-fullwidth is-primary">Enregistrer</button>`;
    }
    // Show timeline
    if (event.target.matches('button[data-action="show-timeline"]')) {

      openModal(mainModal);
      const container = mainModal.querySelector('.modal-card-body');
      const formContainer = mainModal.querySelector('.modal-card-foot');
      container.innerHTML = "<h2>Timeline</h2>";
      const affaireId = event.target.dataset.affaireid;
      console.log(affaireId);
      const url = "./partials/timeline.php?affaireId=" + affaireId;
      async function populateTimeline() {
        fetch(url)
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok ' + response.statusText);
            }
            return response.text(); // Parse the response as text
          })
          .then(data => {
            container.innerHTML = data;
          })
          .catch(error => console.error('There was a problem with the fetch operation:', error));
        // Form
      }
      async function createTimelineForm() {
        const url = './partials/forms/addTimelineEvent.php?affaireid=' + affaireId;
        fetch(url)
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok ' + response.statusText);
            }
            return response.text(); // Parse the response as text
          })
          .then(data => {
            formContainer.innerHTML = data;
          })
          .catch(error => console.error('There was a problem with the fetch operation:', error));
      }
      populateTimeline();
      createTimelineForm();
    }

    // addTimelineEvent
    // document.addEventListener('click', function (event) {
    if (event.target.matches('button[data-action="add-event"]')) {
      event.preventDefault();
      addTimelineEvent();
    }
    // Close live edits
    if (event.target.matches('.button[data-action="closeLiveEdit"], .button[data-action="closeLiveEdit"] *')) {
      event.preventDefault();
      closeLiveEdit();
    }

    // Link to quote
    if (event.target.matches('button[data-action="call-quote-modal"]')) {
      // alert('ok');
      openModal(mainModal);
      const affaireId = event.target.dataset.affaireid;
      async function createQuoteSelectionForm() {
        const url = './partials/forms/linkQuotation.php?affaireid=' + affaireId;
        // const container = mainModal.querySelector('.modal-card-body');
        fetch(url)
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok ' + response.statusText);
            }
            return response.text();
          })
          .then(data => {
            modalBody.innerHTML = data;
            modalTitle.textContent = 'Associer un devis';
            initQuoteLinkerForm();
          })
          .catch(error => console.error('There was a problem with the fetch operation:', error));
      }
      createQuoteSelectionForm();
      // async function createTimelineForm() {
      //   const url = './partials/forms/linkQuotation.php?affaireid=' + affaireId;
      //   const container = mainModal.querySelector('.modal-card-body');
      //   fetch(url)
      //     .then(response => {
      //       if (!response.ok) {
      //         throw new Error('Network response was not ok ' + response.statusText);
      //       }
      //       return response.text(); // Parse the response as text
      //     })
      //     .then(data => {
      //       container.innerHTML = data;
      //     })
      //     .catch(error => console.error('There was a problem with the fetch operation:', error));
      // }

    }
  }); //END OF DYNAMIC CLICK LISTENER





  const searchInput = document.querySelector('#searchAffaire');
  searchInput.addEventListener('input', () => {
    const term = searchInput.value;
    updateMainTable(term);
  })

  async function updateMainTable(search) {
    const mainTable = document.querySelector('#maintable tbody');
    const url = `./affairesList.php?search=${search ? search : ''}`;
    fetch(url)
      .then(response => {
        if (!response.ok) {
          throw new Error('Network response was not ok ' + response.statusText);
        }
        return response.text(); // Parse the response as text
      })
      .then(data => {
        // Insert the PHP content into the div#content
        mainTable.innerHTML = data;
      })
      .catch(error => console.error('There was a problem with the fetch operation:', error));
  }
  updateMainTable();
})


// Compute color according to text content
function stringToColor(str) {
  // Hash the string to a number
  let hash = 0;
  for (let i = 0; i < str.length; i++) {
    hash = str.charCodeAt(i) + ((hash << 5) - hash);
  }

  // Convert the hash into a color by taking the last 6 digits in hexadecimal
  let color = '#';
  for (let i = 0; i < 3; i++) {
    // Extract a part of the hash and make sure it's between 0 and 255
    const value = (hash >> (i * 8)) & 0xFF;
    // Convert the number to a 2-digit hexadecimal
    color += ('00' + value.toString(16)).slice(-2);
  }

  return color;
}
document.addEventListener('DOMContentLoaded', () => {
  const elementsToColor = document.querySelectorAll('.string-color');
  elementsToColor.forEach((element) => {
    const stringContent = element.textContent;
    const color = stringToColor(stringContent);
    element.style.backgroundColor = color;
  })
});

// Update Origin
function initializeOriginSelectors() {
  document.querySelectorAll('select[data-action="set-origin"]').forEach(function (selectElement) {
    // Remove existing event listeners if any
    selectElement.removeEventListener('change', handleSelectChange);

    // Add new event listener
    selectElement.addEventListener('change', handleSelectChange);
  });
}
async function handleDeleteAffaire(event) {
  event.preventDefault(); 
  const confirmation = confirm("Êtes-vous sûr de vouloir supprimer cette affaire ?");
  if (!confirmation) {
    return;
  }
  const formData = new FormData(this);
  console.log('FormData:', formData);

  try {
    const response = await fetch('utils/deleteAffaire.php', {
      method: 'POST',
      body: formData
    });

    console.log('Response Status:', response.status); // Log the status code

    const text = await response.text();
    console.log('Response Text:', text); // Log the raw response

    if (response.ok) {
      try {
        // Attempt to parse the response as JSON
        const data = JSON.parse(text);
        if (data.success) {
          showToast('Affaire supprimée avec succès', 'is-success');
          const lineToRemove = document.querySelector(`tr[data-affaireid="${formData.get('delete_id')}"]`);
          // console.log("removeline : " + formData.get('delete_id'));
          lineToRemove.remove();
        } else {
          showToast('Une erreur est survenue', 'is-warning');
        }
      } catch (e) {
        console.error('Error parsing JSON:', e);
        showToast('Erreur de serveur : réponse non valide', 'is-danger');
      }
    } else {
      showToast('Erreur de serveur : ' + response.status, 'is-danger');
    }
  } catch (error) {
    console.error('Fetch error:', error);
    showToast('Une erreur est survenue', 'is-danger');
  }
}


function initDeleteAffaire() {
  document.querySelectorAll('form:has(input[name="delete_id"])').forEach(form => {
    console.log('Initializing delete form event listener');
    // Pass the function reference without calling it
    form.addEventListener('submit', handleDeleteAffaire);
  });
}


function handleSelectChange() {
  const affaireId = this.getAttribute('data-affaireid');
  const newOrigine = this.value;

  fetch('utils/updateOrigin.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify({
      affaireId: affaireId,
      origine: newOrigine
    })
  })
    .then(response => response.text())
    .then(text => {
      console.log('Response Text:', text);
      try {
        const data = JSON.parse(text);
        if (data.success) {
          showToast('Origine mise à jour');
        } else {
          showToast('Une erreur est survenue', 'is-warning');
        }
      } catch (error) {
        console.error('Error parsing JSON:', error);
      }
    })
    .catch(error => {
      console.error('Fetch error:', error);
      showToast('Une erreur est survenue', 'is-danger');
    });
}



// Mutation Observer
// Function to observe DOM changes
function observeDOMChanges(targetNode, callback) {
  // Options for the observer (which mutations to observe)
  const config = {
    attributes: true,  // Observe attribute changes
    childList: true,   // Observe addition or removal of child nodes
    subtree: true      // Observe the entire subtree starting from targetNode
  };

  // Create an observer instance linked to the callback function
  const observer = new MutationObserver((mutationsList, observer) => {
    // for (const mutation of mutationsList) {
    //     if (mutation.type === 'childList') {
    //         console.log('A child node has been added or removed.');
    //     } else if (mutation.type === 'attributes') {
    //         console.log('The ' + mutation.attributeName + ' attribute was modified.');
    //     }
    // }

    // Call the callback function to handle custom logic on DOM changes
    if (typeof callback === 'function') {
      callback(mutationsList);
    }
  });

  // Start observing the target node for configured mutations
  observer.observe(targetNode, config);

  // Optionally, return the observer to disconnect it later
  return observer;
}

// Use document.body to observe the body element
const targetNode = document.body; // Observe the <body> element

// Custom function to be called when changes are detected
function handleDOMChanges(mutationsList) {
  // NOTE: Here are all functions that are to be called on DOM change
  mutationsList.forEach(mutation => {
    initializeOriginSelectors();
    InitializeUpdateTextForms();
    initDeleteAffaire();
  });
}

// Call the observeDOMChanges function, passing the targetNode and callback
observeDOMChanges(targetNode, handleDOMChanges);

function showToast(message, type = 'is-success') {
  bulmaToast.toast({
    message: message,
    type: type,
    duration: 2000, // Duration of the toast in ms (2 seconds)
    position: 'top-right', // Position of the toast on screen
    dismissible: true, // Allows users to dismiss the toast
    pauseOnHover: true, // Pause the timer when hovered over
  });
}

function InitializeUpdateTextForms() {
  const forms = document.querySelectorAll('form[action="updateTextField.php"]');

  forms.forEach((form) => {
    // Remove any existing 'submit' event listeners
    form.removeEventListener('submit', handleFormSubmit);

    // Add the event listener with a separate function
    form.addEventListener('submit', handleFormSubmit);
  });
}

function handleFormSubmit(e) {
  e.preventDefault();

  const form = e.target;
  const affaireId = form.closest('tr').dataset.affaireid;
  const dbfield = form.querySelector('input[name="dbfield"]').value;
  const content = form.querySelector('input[name="content"]').value;

  console.log(`affaire id : ${affaireId} - dbfield : ${dbfield} - content : ${content}`);

  fetch('utils/updateTextField.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify({
      affaireid: affaireId,
      dbfield: dbfield,
      content: content
    })
  })
    .then(response => response.text())
    .then(text => {
      console.log('Response Text:', text);
      try {
        const data = JSON.parse(text);
        if (data.success) {
          showToast('Modification enregistrée');
        } else {
          showToast('Une erreur est survenue', 'is-warning');
        }
        form.closest('td').innerHTML = content;
      } catch (error) {
        console.error('Error parsing JSON:', error);
      }
    });
}

function closeLiveEdit() {
  // Close all forms
  const liveEdits = document.querySelectorAll('td.editable:has(form)');
  liveEdits.forEach((cell) => {
    const form = cell.querySelector('form');
    if (form) {
      const previousValue = form.dataset.previousvalue;
      // const content = cell.querySelector('input').value;
      cell.innerHTML = previousValue;
    }
  });
}
function initOrderLinkerForms() {
  const forms = document.querySelectorAll('form[data-action="linkOrder"]');
}

async function addTimelineEvent(affaireId, content) {
  if (!affaireId) {
    const form = document.querySelector('form:has(button[data-action="add-event"])');
    content = form.querySelector('textarea').value;
    affaireId = document.querySelector('button[data-action="add-event"]').dataset.affaireid;

  }
  const eventList = document.querySelector('.timeline tbody');
  const container = mainModal.querySelector('.modal-card-body');




  // Create the form data
  const formData = new FormData();
  formData.append('affaireId', affaireId);
  formData.append('content', content);

  fetch('utils/addTimelineEvent.php', {
    method: 'POST',
    body: formData, // Send the affaireId and content as form data
  })
    .then(response => {
      if (!response.ok) {
        throw new Error('Network response was not ok ' + response.statusText);
      }
      return response.text(); // Parse the response as text
    })
    .then(data => {
      // container.innerHTML = data;
      if (eventList) {
        eventList.innerHTML = `<tr><td class="has-text-success">Nouvel élément</td><td>${content}</td></tr>` + eventList.innerHTML;
      }

      // alert('ok');
    })
    .catch(error => console.error('There was a problem with the fetch operation:', error));
}

function initQuoteLinkerForm() {
  const form = document.querySelector('form[data-action="link-quote"]');
  form.addEventListener('submit', (e) => {
    e.preventDefault();
    const quoteRef = e.target.querySelector('input').value;
    const affaireId = e.target.dataset.affaireid;

    async function linkQuote() {
      console.log('quote: ' + quoteRef + ', affaire: ' + affaireId);

      // Use FormData to submit the data as `multipart/form-data`
      const formData = new FormData();
      formData.append('affaireid', affaireId);
      formData.append('quoteRef', quoteRef);

      fetch('utils/linkQuotation.php', {
        method: 'POST',
        body: formData
      })
        .then(response => response.text())
        .then(text => {
          console.log('Response Text:', text);
          try {
            const data = JSON.parse(text);
            if (data.success) {
              showToast('Modification enregistrée');
              // Update the form with some content, if needed
              form.closest('td').innerHTML = 'Updated Content';
            } else {
              showToast('Une erreur est survenue: ' + data.message, 'is-warning');
            }
          } catch (error) {
            console.error('Error parsing JSON:', error);
          }
        })
        .catch(error => {
          console.error('Error:', error);
          showToast('Erreur réseau', 'is-danger');
        });
    }

    linkQuote();
    addTimelineEvent(affaireId, `linkQuotation${quoteRef}`);

  });
  





}
