<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/css/bootstrap.min.css" integrity="sha384-TX8t27EcRE3e/ihU7zmQxVncDAy5uIKz4rEkgIXeMed4M0jlfIDPvg6uqKI2xXr2" crossorigin="anonymous">

    <title>Commandes à préparer</title>
    <link href="open-iconic/font/css/open-iconic-bootstrap.css" rel="stylesheet">
    <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"
  />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha512-9usAa10IRO0HhonpyAIVpjrylPvoDwiPUiKdWk5t3PyolY1cOd4DSE0Ga+ri4AuTroPR5aQvXU9xC6qOPnzFeg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="inside.css" rel="stylesheet">
  </head>
  <body id="apreparer" class="body-dark">
<div class="container-fluid">
  <?php   include 'navbar.php'; ?>
</div>
    <div class="container">
      
<?php
include 'db.php';
// Create connection
$link = new mysqli($servername, $username, $pass, $dbname);
$link->set_charset("utf8");
// Check connection
if ($link->connect_error) {
die("Connection failed: " . $link->connect_error);
}
// echo "<table>";
$sql = "Select
    ps_orders.reference As 'refcmde',
    ps_order_state_lang.name As 'statecmde',
    ps_order_state.color As 'color',
    ps_carrier.name As 'carrier',
    ps_address.address1 As 'add1',
    ps_address.address2 As 'add2',
    ps_address.postcode As 'postcode',
    ps_address.city As 'city',
    ps_address.firstname As 'prenom',
    ps_address.lastname As 'nom',
    ps_message.message As 'msg',
    ps_order_carrier.weight As 'kg',
    ps_customer.id_default_group As 'group',
    Concat (ps_customer.company, ' -<span class=\"small\">', ps_customer.firstname, ' ',  ps_customer.lastname, '</span>') As 'nomclient'
From
    ps_orders Inner Join
    ps_order_state_lang On ps_orders.current_state = ps_order_state_lang.id_order_state Inner Join
    ps_address On ps_orders.id_address_delivery = ps_address.id_address Inner Join
    ps_carrier On ps_orders.id_carrier = ps_carrier.id_carrier Inner Join
    ps_message On ps_orders.id_order = ps_message.id_order Inner join
    ps_order_carrier On ps_orders.id_order = ps_order_carrier.id_order Inner join
    ps_order_state On ps_orders.current_state = ps_order_state.id_order_state
    Inner join
    ps_customer On ps_orders.id_customer = ps_customer.id_customer
Where
    ps_orders.current_state In (3, 2, 9, 25, 39, 48)
    Or
    ps_orders.current_state = '10' And ps_customer.id_default_group In ('9', '13')
    Order by
    ps_orders.date_add Desc";
$result = $link->query($sql);

if ($result->num_rows > 0) {
  echo "<h1>Commandes à préparer (".$result->num_rows.")</h1>";
// output data of each row
while($row = $result->fetch_assoc()) {
  echo "<div id='bp".$row["refcmde"]."' class='card oneorder'><div class='card-body'>";
echo "<h2><span style='display:none'><input type='checkbox' name='dropship'><label for='dropship'>En cours</label></span>" . $row["refcmde"];
echo "<span class='small'>&nbsp;" . $row["nomclient"]."</span>";
echo "<span class='badge float-right small orderstate' style='float:right;width:auto;font-size:14px;font-weight:300;background-color:".$row["color"]."'>" . $row["statecmde"]. " </span>" ;
echo "<a class='btn' onclick='PrintElem(\"#bp".$row["refcmde"]."\")'><span class='oi oi-print' title='print' aria-hidden='true'></span></a>";
echo "<form action='demande-affretement.php' method='post' target='affretement'><input type='text' id='refcmde' name='refcmde' value='".$row["refcmde"]."' style='display:none'><button type='submit' value='Affrètement' data-toggle='modal' data-target='#modalaffretement' class='btn btn-primary float-right noprint'><i class='fa fa-truck'></i> Affrètement</button></form>";

if ($row["group"] == '9'){
echo "<span style='font-size:14px;font-weight:300;background-color:gold;float:right;padding:10px;color:black'>Manutan</span>";
}
if ($row["group"] == '13'){
echo "<span style='font-size:14px;font-weight:300;background-color:blue;float:right;padding:10px;color:black'>Ital Express</span>";
}
echo "</h2>";
echo "<table class='table' style='width:100%;display:block;'><tr>";
if ($row["carrier"] == "Retrait sur place"){
  echo "<td><h4>Retrait sur place</h4></td>";
}
else{
echo "<td><h4>".$row["carrier"]."</h4><h5>Adresse de livraison</h5>". $row["prenom"]. "&nbsp;". $row["nom"]."<br/>".$row["add1"]."&nbsp;".$row["add2"]."<br/>".$row["postcode"]."<br/>".$row["city"]."<br/><strong>Poids total : " .number_format((float)$row["kg"], 2, '.', '') ." Kg</strong></td>";
}
// if ($row["msg"], 'Action') {
//   echo "<td>".$row["msg"]."</td>";
// }
// else{
//   echo "<td>pas de message</td>";
// }
$mystring = $row["msg"];
$word="Action réalisée";
if(strpos($mystring, $word) !== false){
    // echo "Word Found!";
    echo "<td></td>";
} else{
    // echo "Word Not Found!";
     echo "<td><h5>Message</h5>".$row["msg"]."</td>";
}


echo "</tr></table>";
// Sous requete
$sqll = "Select
    ps_orders.reference As 'oref',
    ps_order_detail.product_reference As 'prodref',
    ps_order_detail.product_name As 'prodname',
    ps_order_detail.product_quantity As 'prodqty',
    ps_order_detail.product_supplier_reference As 'supplyref',
    ps_supplier.name As 'supplier',
    Case
        When ps_product.height = 0
        Then ''
        Else 'Dropshipping'
    End As 'prodship'
From
    ps_orders Inner Join
    ps_order_detail On ps_orders.id_order = ps_order_detail.id_order Inner Join
    ps_product On ps_order_detail.product_id = ps_product.id_product Inner Join
    ps_supplier On ps_product.id_supplier = ps_supplier.id_supplier
  WHERE ps_orders.reference='".$row["refcmde"]."'";
$resultt = $link->query($sqll);
if ($resultt->num_rows > 0) {
  echo "<table class='table table-striped text-center maintable' style='display:table;width:100%'>";
  echo "<thead><tr><th>Nom</th><th>Reference</th><th>Qté.</th><th></th><th class='noscreen'>&nbsp;</th></tr></thead>";
// output data of each row
while($roww = $resultt->fetch_assoc()) {
echo "<tr style='border-bottom:solid 1px #666'>";
echo "<td>" . $roww["prodname"]. "</td>";
echo "<td><strong>" . $roww["prodref"]. "</strong></td>";
echo "<td><strong>" . $roww["prodqty"]. "</strong></td>";
if($roww["prodship"] == 'Dropshipping'){
  echo "<td>";
  // controle des demandes de  dropshipping
  $querydropship = "Select
      ps_bms_procurement_purchase_order.reference As 'refdropship',
      ps_bms_procurement_purchase_order.comments_private,
      ps_bms_procurement_purchase_order.status_id,
      ps_bms_procurement_purchase_order_status.name,
      ps_bms_procurement_purchase_order.eta,
      ps_bms_procurement_purchase_order_product.sku,
      ps_bms_procurement_purchase_order_product.supplier_sku,
      ps_bms_procurement_purchase_order_product.qty_ordered
  From
      ps_bms_procurement_purchase_order Inner Join
      ps_bms_procurement_purchase_order_status On ps_bms_procurement_purchase_order.status_id =
              ps_bms_procurement_purchase_order_status.id_bms_procurement_purchase_order_status Inner Join
      ps_bms_procurement_purchase_order_product On ps_bms_procurement_purchase_order.id_bms_procurement_purchase_order =
              ps_bms_procurement_purchase_order_product.po_id
              Where ps_bms_procurement_purchase_order.comments_private Like '%".$row["refcmde"]."%' And ps_bms_procurement_purchase_order_product.sku = '". $roww["prodref"]."'
              Order by
              ps_bms_procurement_purchase_order.status_id Asc";
              $resultdropship = $link->query($querydropship);
              if ($resultdropship->num_rows > 0) {
                while($rowdropship = $resultdropship->fetch_assoc()) {
                echo "<button class='btn btn-sm btn-success'data-toggle='popover' title='Commande passée' data-content='".$rowdropship["refdropship"]."'><i class='fa fa-check'></i> Dropship. OK</button>";
              }
              }
              else{
                echo "<button class='btn btn-sm btn-danger'data-toggle='popover' title='Dropship.".$roww["supplier"]."' data-content='Ref : ".$roww["supplyref"]."'><i class='fa fa-remove'></i> Dropship.  </button>";
              }
  // FIN controle des demandes de  dropshipping
  echo "</td>";
}
else {
  echo "<td>" . $roww["prodship"]. "</td>";
}
echo "<td style='width:80px;' class='noscreen'><div style='width:20px;height:20px;border:solid 2px #000;display:block;'</td>";
echo "</tr> ";
}
echo "</table>";

}
// Sous requete
echo "</div></div>";
}

} else {
echo "0 results";
}

// echo "</table>";
$link->close();
?>
</div>

<!-- Modal -->
<div class="modal fade" id="modalaffretement" tabindex="-1" role="dialog" aria-labelledby="modalaffretementLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalaffretementLabel">Demande d'affrètement</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <iframe name="affretement" id="affretement" width="750" height="600" border="0" style="border:0"></iframe>
        <iframe name="affretementretour" id="affretementretour" width="700" height="150" border="0" style="border:0"></iframe>
      </div>
      <div class="modal-footer">
        <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary">Save changes</button> -->
      </div>
    </div>
  </div>
</div>
    <!-- Option 1: jQuery and Bootstrap Bundle (includes Popper) -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ho+j7jyWK8fNQe+A12Hb8AhRq26LrZ/JpcUGGOn+Y7RsweNrtN/tE3MoK7ZeZDyx" crossorigin="anonymous"></script>
    <script src="js/inside.js"></script>


  </body>
</html>
