const mainModal = document.querySelector('#mainmodal');
document.addEventListener('DOMContentLoaded', () => {
  // Functions to open and close a modal
  function openModal($el) {
    $el.classList.add('is-active');
  }

  function closeModal($el) {
    $el.classList.remove('is-active'); 
  }

  function closeAllModals() {
    (document.querySelectorAll('.modal') || []).forEach(($modal) => {
      closeModal($modal);
    });
  }

  // Add a click event on buttons to open a specific modal
  (document.querySelectorAll('.js-modal-trigger') || []).forEach(($trigger) => {
    const modal = $trigger.dataset.target;
    const $target = document.getElementById(modal);

    $trigger.addEventListener('click', () => {
      openModal($target);
    });
  });

  // Add a click event on various child elements to close the parent modal
  (document.querySelectorAll('.modal-background, .modal-close, .modal-card-head .delete, .modal-card-foot .button') || []).forEach(($close) => {
    const $target = $close.closest('.modal');

    $close.addEventListener('click', () => {
      closeModal($target);
    });
  });

  // Add a keyboard event to close all modals
  document.addEventListener('keydown', (event) => {
    if (event.key === "Escape") {
      closeAllModals();
    }
  });
  // Link to customer account
  const linkCustomerBtns = document.querySelectorAll('button[data-action="linkCustomer"]');

  // Délégation du click
  document.body.addEventListener('click', function (event) {
    const target = event.target;
    // Link au compte client
    if (event.target.matches('.button[data-action="linkCustomer"], .button[data-action="linkCustomer"] *')) {
      // alert('clicked');
      openModal(mainModal);
      const container = mainModal.querySelector('.modal-card-body');
      const affaireId = event.target.dataset.affaireid;
      const customerId = event.target.dataset.customerid;
      fetch('./utils/linkCustomer.php?affaireId=' + affaireId + '&customerId=' + customerId)
        .then(response => response.text())
        .then(html => {
          container.innerHTML = html;
          document.querySelector('.modal-card-title').textContent = "Affaire liée au client";
        })
        .catch(error => console.error('Error loading content:', error));
      // });
    }
    // editable cells
    if (event.target.matches('.editable')) {

      const previousValue = target.textContent;
      target.innerHTML = `<div class="field">                   
                    <div class="control">
                        <input class="input" type="text" placeholder="entrer" value=${previousValue}>
                    </div>
                </div>`;


    };
    // Show content in modal
    if (target.matches('.fullContentModal')) {
      openModal(mainModal);
      const container = mainModal.querySelector('.modal-card-body');
      document.querySelector('.modal-card-title').textContent = target.dataset.title;
      // })
      container.innerHTML = `<textarea class="textarea" >${target.textContent}</textarea><button class="button is-fullwidth is-primary">Enregistrer</button>`;
    }
    // Show timeline
    if (event.target.matches('button[data-action="show-timeline"]')) {

      openModal(mainModal);
      const container = mainModal.querySelector('.modal-card-body');
      const formContainer = mainModal.querySelector('.modal-card-foot');
      container.innerHTML = "<h2>Timeline</h2>";
      const affaireId = event.target.dataset.affaireid;
      console.log(affaireId);
      const url = "./partials/timeline.php?affaireId=" + affaireId;
      async function populateTimeline() {
        fetch(url)
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok ' + response.statusText);
            }
            return response.text(); // Parse the response as text
          })
          .then(data => {
            container.innerHTML = data;
          })
          .catch(error => console.error('There was a problem with the fetch operation:', error));
        // Form
      }
      async function createTimelineForm() {
        const url = './partials/forms/addTimelineEvent.php?affaireid=' + affaireId;
        fetch(url)
          .then(response => {
            if (!response.ok) {
              throw new Error('Network response was not ok ' + response.statusText);
            }
            return response.text(); // Parse the response as text
          })
          .then(data => {
            formContainer.innerHTML = data;
          })
          .catch(error => console.error('There was a problem with the fetch operation:', error));
      }
      populateTimeline();
      createTimelineForm();
    }

    // addTimelineEvent
    // document.addEventListener('click', function (event) {
    if (event.target.matches('button[data-action="add-event"]')) {
      event.preventDefault();
      addTimelineEvent();
    }
    // });

    // };
  }); //END OF DYNAMIC CLICK LISTENER


  async function addTimelineEvent() {
    const container = mainModal.querySelector('.modal-card-body');
    const form = document.querySelector('form:has(button[data-action="add-event"])');
    const content = form.querySelector('textarea').value;
    const affaireId = document.querySelector('button[data-action="add-event"]').dataset.affaireid;

    const eventList = document.querySelector('.timeline tbody');

    // Create the form data
    const formData = new FormData();
    formData.append('affaireId', affaireId);
    formData.append('content', content);

    fetch('utils/addTimelineEvent.php', {
      method: 'POST',
      body: formData, // Send the affaireId and content as form data
    })
      .then(response => {
        if (!response.ok) {
          throw new Error('Network response was not ok ' + response.statusText);
        }
        return response.text(); // Parse the response as text
      })
      .then(data => {
        // container.innerHTML = data;
        eventList.innerHTML = `<tr><td class="has-text-success">Nouvel élément</td><td>${content}</td></tr>` + eventList.innerHTML;
        // alert('ok');
      })
      .catch(error => console.error('There was a problem with the fetch operation:', error));
  }


  const searchInput = document.querySelector('#searchAffaire');
  searchInput.addEventListener('input', () => {
    const term = searchInput.value;
    updateMainTable(term);
  })

  async function updateMainTable(search) {
    const mainTable = document.querySelector('#maintable tbody');
    const url = `./affairesList.php?search=${search ? search : ''}`;
    fetch(url)
      .then(response => {
        if (!response.ok) {
          throw new Error('Network response was not ok ' + response.statusText);
        }
        return response.text(); // Parse the response as text
      })
      .then(data => {
        // Insert the PHP content into the div#content
        mainTable.innerHTML = data;
      })
      .catch(error => console.error('There was a problem with the fetch operation:', error));
  }
  updateMainTable();
})
