{**
 * 2007-2019 PrestaShop and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/OSL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}

<table id="summary-tab" width="100%">
{assign var="qte_biens" value=0}
{assign var="qte_services" value=0}
	{foreach $order_details as $order_detail}
	{if $order_detail.is_virtual == 0}
  {$qte_biens = $qte_biens + 1}
{else}
{$qte_services = $qte_services + 1}
  {/if}
	{/foreach}
	<tr>
		<th {if $addresses.invoice->vat_number} colspan="5" {else} colspan="4"{/if} class="header small" valign="middle">
			Nature de l'opération :
			{if $qte_biens > 0 && $qte_services > 0}
			Mixte (biens et services)
			{else}
				{if $qte_biens > 0}
				Biens
				{/if}
				{if $qte_services > 0}
				biens
				{/if}
			{/if}
		</th>
	</tr>
	<tr>
		<th class="header small" valign="middle">{l s='Invoice Number' d='Shop.Pdf' pdf='true'}</th>
		<th class="header small" valign="middle">{l s='Invoice Date' d='Shop.Pdf' pdf='true'}</th>
		<th class="header small" valign="middle">{l s='Order Reference' d='Shop.Pdf' pdf='true'}</th>
		<th class="header small" valign="middle">{l s='Order date' d='Shop.Pdf' pdf='true'}</th>
		{if $addresses.invoice->vat_number}
			<th class="header small" valign="middle">{l s='VAT Number' d='Shop.Pdf' pdf='true'}</th>
		{/if}
	</tr>
	<tr>
		<td class="center small white">{$title|escape:'html':'UTF-8'}</td>
		<td class="center small white">{dateFormat date=$order->invoice_date full=0}</td>
		<td class="center small white">{$order->getUniqReference()}</td>
		<td class="center small white">{dateFormat date=$order->date_add full=0}</td>
		{if $addresses.invoice->vat_number}
			<td class="center small white">
				{$addresses.invoice->vat_number}
			</td>
		{/if}
	</tr>

	{if $order->module == "ps_checkpayment"}
	{assign var="date_facture" value=$order->invoice_date|date_format:"Y-m-d"}
	{assign var="month_due" value="$date_facture +1 month"|strtotime|date_format:"m-Y"}
	{assign var="date_fin_de_mois" value="01-$month_due"}
	{assign var="date_due" value="$date_fin_de_mois +29 days"|strtotime|date_format:"d-m-Y"}

	  <tr>
	    <td class="center small white" {if $addresses.invoice->vat_number}colspan="5"{else}colspan="4"{/if} >Paiement à 30 jours fin de mois. Date d'échéance : {$date_due}</td>
	  </tr>
	{/if}
</table>
